/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component.combo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import org.openconcerto.ui.component.combo.ISearchableCombo;
import org.openconcerto.ui.component.combo.ISearchableComboItem;
import org.openconcerto.utils.model.SimpleListDataListener;

public class ISearchableComboPopup<T>
extends JPopupMenu {
    private static final int MAXROW = 10;
    private final JList list;
    private int minWitdh = 150;
    private final ISearchableCombo<T> text;

    ISearchableComboPopup(ListModel listModel, ISearchableCombo<T> text) {
        this.list = new JList(listModel);
        this.text = text;
        this.uiInit();
        this.list.addMouseMotionListener(new ListMouseMotionHandler());
        this.getListModel().addListDataListener(new SimpleListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                int rowCount = Math.min(ISearchableComboPopup.this.getListModel().getSize(), 30);
                ISearchableComboPopup.this.list.setVisibleRowCount(rowCount);
                if (rowCount > 0 && ISearchableComboPopup.this.isVisible()) {
                    ISearchableComboPopup.this.setVisible(false);
                    ISearchableComboPopup.this.setVisible(true);
                }
            }
        });
    }

    private ISearchableCombo<T> getCombo() {
        return this.text;
    }

    private ListModel getListModel() {
        return this.list.getModel();
    }

    private void uiInit() {
        this.list.setFocusable(false);
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ISearchableComboPopup.this.validateSelection();
            }
        });
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel comp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                comp.setFont(ISearchableComboPopup.this.getCombo().getFont());
                if (value instanceof Action) {
                    comp.setText((String)((Action)value).getValue("Name"));
                    comp.setIcon(null);
                } else {
                    ISearchableComboItem val = (ISearchableComboItem)value;
                    comp.setText(val.asString());
                    comp.setIcon(ISearchableComboPopup.this.getCombo().getIcon(val));
                    if (ISearchableComboPopup.this.getCombo().isEmptyItem(val)) {
                        comp.setFont(comp.getFont().deriveFont(2));
                    }
                }
                return comp;
            }
        });
        JScrollPane scroller = new JScrollPane(this.list, 20, 31);
        scroller.setFocusable(false);
        scroller.getVerticalScrollBar().setFocusable(false);
        scroller.setBorder(null);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setOpaque(true);
        this.add(scroller);
        this.setFocusable(false);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        int width = d.width;
        if (width > 500) {
            width = 500;
        }
        width = Math.max(width, this.minWitdh) + 2;
        Dimension newD = new Dimension(width, d.height);
        return newD;
    }

    public void setMinWith(int i) {
        this.minWitdh = i;
    }

    protected void updateListBoxSelection(Point location) {
        this.updateListBoxSelection(location, true);
    }

    private void updateListBoxSelection(Point location, boolean shouldScroll) {
        if (this.list == null) {
            return;
        }
        int index = this.list.locationToIndex(location);
        if (index == -1) {
            index = location.y < 0 ? 0 : this.getListModel().getSize() - 1;
        }
        if (this.list.getSelectedIndex() != index) {
            this.list.getSelectionModel().setSelectionInterval(index, index);
            if (shouldScroll) {
                this.list.ensureIndexIsVisible(index);
            }
        }
    }

    public void selectNext() {
        int i = this.list.getSelectedIndex() + 1;
        if (i < this.getListModel().getSize()) {
            this.list.setSelectedIndex(i);
            this.list.ensureIndexIsVisible(i);
        }
    }

    public void selectNextPage() {
        int i = Math.min(10 + Math.max(this.list.getSelectedIndex(), 0), this.getListModel().getSize() - 1);
        if (i < this.getListModel().getSize()) {
            this.list.setSelectedIndex(i);
            this.list.ensureIndexIsVisible(i);
        }
    }

    public void selectPrevious() {
        int i = this.list.getSelectedIndex() - 1;
        if (i >= 0) {
            this.list.setSelectedIndex(i);
            this.list.ensureIndexIsVisible(i);
        } else {
            this.setVisible(false);
        }
    }

    public void selectPreviousPage() {
        int i = Math.max(0, this.list.getSelectedIndex() - 10);
        this.list.setSelectedIndex(i);
        this.list.ensureIndexIsVisible(i);
    }

    final void validateSelection() {
        Object sel = this.list.getSelectedValue();
        if (sel != null) {
            if (sel instanceof ISearchableComboItem) {
                this.getCombo().setValue(((ISearchableComboItem)sel).getOriginal());
            } else if (sel instanceof Action) {
                ((Action)sel).actionPerformed(new ActionEvent(this.getCombo(), 1001, this.getCombo().getName()));
            } else {
                throw new IllegalStateException("unknown selection: " + sel);
            }
            this.setVisible(false);
        }
    }

    public void open() {
        if (!this.isShowing()) {
            this.show(this.getCombo(), 0, this.getCombo().getBounds().height);
        }
        this.list.setSelectedValue(this.getCombo().getSelection(), true);
    }

    public void close() {
        this.setVisible(false);
    }

    protected class ListMouseMotionHandler
    extends MouseMotionAdapter {
        protected ListMouseMotionHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent anEvent) {
            ISearchableComboPopup.this.updateListBoxSelection(anEvent.getPoint());
        }
    }
}

