/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.openconcerto.ui.DefaultListModel;
import org.openconcerto.ui.component.ITextSelector;

public class ITextSelectorPopup
extends JPopupMenu {
    private static final int MAXROW = 10;
    private JList list;
    private ListModel listModel;
    private int minWitdh = 150;
    private ITextSelector text;

    ITextSelectorPopup(DefaultListModel listModel, ITextSelector text) {
        this.listModel = listModel;
        this.text = text;
        this.uiInit();
        this.list.addMouseMotionListener(new ListMouseMotionHandler());
    }

    private void uiInit() {
        this.list = new JList(this.listModel);
        this.list.setFocusable(false);
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ITextSelectorPopup.this.validateSelection();
            }
        });
        JScrollPane scroller = new JScrollPane(this.list, 20, 31);
        scroller.setFocusable(false);
        scroller.getVerticalScrollBar().setFocusable(false);
        scroller.setBorder(null);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setOpaque(true);
        this.add(scroller);
        this.setFocusable(false);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        int width = d.width;
        if (width > 500) {
            width = 500;
        }
        width = Math.max(width, this.minWitdh) + 2;
        Dimension newD = new Dimension(width, d.height);
        return newD;
    }

    public void setMinWith(int i) {
        this.minWitdh = i;
    }

    protected void updateListBoxSelectionForEvent(MouseEvent anEvent, boolean shouldScroll) {
        Point location = anEvent.getPoint();
        if (this.list == null) {
            return;
        }
        int index = this.list.locationToIndex(location);
        if (index == -1) {
            index = location.y < 0 ? 0 : this.listModel.getSize() - 1;
        }
        if (this.list.getSelectedIndex() != index) {
            this.list.setSelectedIndex(index);
            if (shouldScroll) {
                this.list.ensureIndexIsVisible(index);
            }
        }
    }

    public void selectNext() {
        int i = this.list.getSelectedIndex() + 1;
        if (i < this.listModel.getSize()) {
            this.list.setSelectedIndex(i);
            this.list.ensureIndexIsVisible(i);
        }
    }

    public void selectNextPage() {
        int i = Math.min(10 + Math.max(this.list.getSelectedIndex(), 0), this.listModel.getSize() - 1);
        if (i < this.listModel.getSize()) {
            this.list.setSelectedIndex(i);
            this.list.ensureIndexIsVisible(i);
        }
    }

    public void selectPrevious() {
        int i = this.list.getSelectedIndex() - 1;
        if (i >= 0) {
            this.list.setSelectedIndex(i);
            this.list.ensureIndexIsVisible(i);
        } else {
            this.setVisible(false);
        }
    }

    public void selectPreviousPage() {
        int i = Math.max(0, this.list.getSelectedIndex() - 10);
        this.list.setSelectedIndex(i);
        this.list.ensureIndexIsVisible(i);
    }

    public void validateSelection() {
        Object element = this.list.getSelectedValue();
        if (element == null) {
            element = this.list.getModel().getElementAt(0);
        }
        if (element == null) {
            return;
        }
        this.text.setValue(element.toString());
        this.setVisible(false);
    }

    protected class ListMouseMotionHandler
    extends MouseMotionAdapter {
        protected ListMouseMotionHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent anEvent) {
            Point location = anEvent.getPoint();
            Rectangle r = new Rectangle();
            ITextSelectorPopup.this.list.computeVisibleRect(r);
            if (r.contains(location)) {
                ITextSelectorPopup.this.updateListBoxSelectionForEvent(anEvent, true);
            }
        }
    }
}

