/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import org.openconcerto.ui.DefaultListModel;
import org.openconcerto.ui.component.ITextSelector;

public class ITextSelectorCompletionThread
extends Thread {
    private final ITextSelector combo;
    private final boolean showAll;
    private final String t;
    private boolean stopNow;

    public ITextSelectorCompletionThread(ITextSelector combo, boolean showAll, String t) {
        this.combo = combo;
        this.showAll = showAll;
        this.t = t;
        this.stopNow = false;
    }

    @Override
    public void run() {
        this.computeAutoCompletion();
    }

    public synchronized void stopNow() {
        this.stopNow = true;
    }

    private synchronized boolean isStopped() {
        return this.stopNow;
    }

    private void computeAutoCompletion() {
        final List<String> l = !this.showAll ? this.getPossibleValues() : this.getFirsValues();
        final DefaultListModel model = this.combo.getModel();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ITextSelectorCompletionThread.this.isStopped()) {
                    return;
                }
                model.removeAllElements();
                model.addAll(l);
                if (l.size() > 1) {
                    ITextSelectorCompletionThread.this.combo.showCompletionPopup();
                } else if (l.size() == 1) {
                    String str = (String)l.get(0);
                    if (str.trim().equalsIgnoreCase(ITextSelectorCompletionThread.this.t.trim())) {
                        ITextSelectorCompletionThread.this.combo.hideCompletionPopup();
                    } else {
                        ITextSelectorCompletionThread.this.combo.showCompletionPopup();
                    }
                } else {
                    ITextSelectorCompletionThread.this.combo.hideCompletionPopup();
                }
            }
        });
    }

    private List<String> getFirsValues() {
        ArrayList<String> result = new ArrayList<String>();
        List<String> cache = this.combo.getCache();
        int maximumResult = this.combo.getMaximumResult();
        int index = 0;
        while (index < cache.size()) {
            String item = cache.get(index);
            result.add(item);
            if (result.size() > maximumResult) break;
            ++index;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<String> getPossibleValues() {
        ArrayList<String> result = new ArrayList<String>();
        String aText = this.t.trim().toLowerCase();
        int minimumSearch = this.combo.getMinimumSearch();
        if (aText.length() < minimumSearch) return result;
        List<String> values = ITextSelectorCompletionThread.cut(aText);
        int stop = values.size();
        List<String> cache = this.combo.getCache();
        int completionMode = this.combo.getCompletionMode();
        int maximumResult = this.combo.getMaximumResult();
        int index = 0;
        while (index < cache.size()) {
            String item = cache.get(index);
            boolean ok = false;
            if (index % 50 == 0 && this.isStopped()) {
                return result;
            }
            String lowerCaseItem = item.toLowerCase();
            int j = 0;
            while (j < stop) {
                block14: {
                    String lowerCaseValue = values.get(j).toLowerCase();
                    if (completionMode == 2) {
                        if (lowerCaseItem.indexOf(lowerCaseValue) >= 0) {
                            ok = true;
                            break block14;
                        } else {
                            ok = false;
                            break;
                        }
                    }
                    if (lowerCaseItem.startsWith(lowerCaseValue)) {
                        ok = true;
                    } else {
                        ok = false;
                        break;
                    }
                }
                ++j;
            }
            boolean removeDuplicate = true;
            if (ok && removeDuplicate) {
                int i = 0;
                while (i < result.size()) {
                    if (this.isStopped()) {
                        return result;
                    }
                    String element = (String)result.get(i);
                    if (element.equalsIgnoreCase(item)) {
                        ok = false;
                        break;
                    }
                    ++i;
                }
            }
            if (ok) {
                result.add(item);
            }
            if (result.size() > maximumResult) {
                return result;
            }
            ++index;
        }
        return result;
    }

    private static final List<String> cut(String value) {
        ArrayList<String> v = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(value);
        while (tokenizer.hasMoreElements()) {
            String element = (String)tokenizer.nextElement();
            v.add(element);
        }
        return v;
    }
}

