/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.color.ColorSpace;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.openconcerto.ui.DefaultListModel;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.component.ITextComboCache;
import org.openconcerto.ui.component.ITextSelectorCompletionThread;
import org.openconcerto.ui.component.ITextSelectorPopup;
import org.openconcerto.ui.component.MutableListCombo;
import org.openconcerto.ui.component.MutableListComboPopupListener;
import org.openconcerto.ui.component.combo.ISearchableCombo;
import org.openconcerto.ui.component.text.DocumentComponent;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.valuewrapper.ValueChangeSupport;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.model.ListComboBoxModel;

public class ITextSelector
extends JPanel
implements ValueWrapper<String>,
DocumentComponent,
DocumentListener,
TextComponent {
    public static final int MODE_STARTWITH = 1;
    public static final int MODE_CONTAINS = 2;
    private final int modeCompletion = 2;
    protected ITextSelectorPopup popupCompletion;
    private final DefaultListModel model = new DefaultListModel();
    private final ComboLockedMode locked;
    private final ValueChangeSupport supp;
    private static final String DEFAULTVALUE = "";
    private boolean cacheLoading;
    private String objToSelect;
    private boolean cacheSet;
    private ITextComboCache cache;
    private boolean completionEnabled = true;
    private JTextComponent text;
    private boolean multiline = false;
    private final ListComboBoxModel listComboBoxModel = new ListComboBoxModel();
    private Image i;
    private int minimumSearch = 1;
    private int maximumResult = 300;
    private MouseAdapter mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            boolean buttonClicked;
            boolean bl = buttonClicked = ITextSelector.this.getWidth() - e.getX() < 24 && e.getY() < 24;
            if (ITextSelector.this.isLocked()) {
                buttonClicked = true;
            }
            if (buttonClicked && e.getButton() == 1) {
                ITextSelector.this.updateAutoCompletion(true);
            }
        }
    };
    static Image imageSelectorEnabled;
    static Image imageSelectorDisabled;
    ITextSelectorCompletionThread th = null;

    public ITextSelector() {
        this(DEFAULTVALUE);
    }

    public ITextSelector(String defaultValue) {
        this(defaultValue, ComboLockedMode.UNLOCKED, 0);
    }

    public ITextSelector(boolean locked) {
        this(locked ? ComboLockedMode.LOCKED : ComboLockedMode.UNLOCKED);
    }

    public ITextSelector(ComboLockedMode mode) {
        this(DEFAULTVALUE, mode, 0);
    }

    private static void initImages() {
        if (imageSelectorEnabled != null) {
            return;
        }
        Image ic = new ImageIcon(ISearchableCombo.class.getResource("yellowDownArrow.png")).getImage();
        int w = ic.getWidth(null);
        int h = ic.getHeight(null);
        imageSelectorEnabled = new BufferedImage(w, h, 2);
        Graphics g = imageSelectorEnabled.getGraphics();
        g.drawImage(ic, 0, 0, null);
        g.dispose();
        imageSelectorDisabled = new BufferedImage(w, h, 2);
        Graphics2D g2d = (Graphics2D)imageSelectorDisabled.getGraphics();
        ColorSpace cs = ColorSpace.getInstance(1003);
        ColorConvertOp op = new ColorConvertOp(cs, g2d.getRenderingHints());
        op.filter((BufferedImage)imageSelectorEnabled, (BufferedImage)imageSelectorDisabled);
    }

    public ITextSelector(String defaultValue, ComboLockedMode mode, int columns) {
        ITextSelector.initImages();
        this.i = imageSelectorEnabled;
        if (this.multiline) {
            throw new IllegalStateException("Not yet Implemented");
        }
        this.text = new JTextField(columns){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (ITextSelector.this.cache != null) {
                    g.drawImage(ITextSelector.this.i, this.getBounds().width - 16, 6, null);
                }
            }
        };
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        c.gridx = 0;
        c.gridx = 0;
        c.weightx = 1.0;
        this.add((Component)this.text, c);
        this.setTextEditor(this.text);
        this.popupCompletion = new ITextSelectorPopup(this.model, this);
        this.supp = new ValueChangeSupport<String>(this);
        this.locked = mode;
        this.cache = null;
        this.cacheSet = false;
        this.cacheLoading = false;
        this.setMinimumSize(new Dimension(100, 22));
        this.setPreferredSize(new Dimension(140, 22));
        this.objToSelect = defaultValue;
        if (mode == ComboLockedMode.LOCKED) {
            this.setEditable(false);
        }
    }

    protected final ComboLockedMode getMode() {
        return this.locked;
    }

    private boolean isLocked() {
        return this.locked == ComboLockedMode.LOCKED;
    }

    public void initCache(ITextComboCache acache) {
        System.err.println("ITextSelector Cache init:" + acache);
        if (this.cache != null) {
            throw new IllegalStateException("cache already set " + this.cache);
        }
        this.cache = acache;
        new MutableListComboPopupListener(new MutableListCombo(){

            @Override
            public ComboLockedMode getMode() {
                return ITextSelector.this.getMode();
            }

            @Override
            public Component getPopupComp() {
                return ITextSelector.this.getTextComp();
            }

            @Override
            public void addCurrentText() {
                ITextSelector.this.addCurrentText();
            }

            @Override
            public void removeCurrentText() {
                ITextSelector.this.removeCurrentText();
            }
        }).listen();
        this.checkCache();
    }

    private ListComboBoxModel getListModel() {
        return this.listComboBoxModel;
    }

    public void setEditable(boolean b) {
        this.text.setEditable(b);
        if (!b) {
            this.text.setBackground(Color.WHITE);
        }
    }

    private final synchronized void checkCache() {
        if (!this.cacheSet) {
            this.cacheLoading = true;
            this.setEditable(false);
            SwingWorker<List<String>, Object> sw = new SwingWorker<List<String>, Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void done() {
                    try {
                        List l = (List)this.get();
                        System.out.println(".finished()" + l.size());
                        ITextSelector.this.getListModel().removeAllElements();
                        ITextSelector.this.getListModel().addAll(l);
                        if (ITextSelector.this.isLocked() && ITextSelector.this.cache.getCache().size() == 0) {
                            throw new IllegalStateException(ITextSelector.this + " locked but no items.");
                        }
                        if (!ITextSelector.this.isLocked()) {
                            ITextSelector.this.setEditable(true);
                        }
                        4 var2_2 = this;
                        synchronized (var2_2) {
                            ITextSelector.this.cacheLoading = false;
                            ITextSelector.this.cacheSet = true;
                        }
                        ITextSelector.this.setValue(ITextSelector.this.objToSelect);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                protected List<String> doInBackground() throws Exception {
                    return ITextSelector.this.cache.getCache();
                }
            };
            sw.execute();
        }
    }

    DefaultListModel getModel() {
        return this.model;
    }

    private final boolean addToCache(String s) {
        if (s != null && s.length() > 0 && this.getListModel().getList().indexOf(s) < 0) {
            this.cache.addToCache(s);
            return true;
        }
        return false;
    }

    private final void removeCurrentText() {
        String t = this.text.getText();
        this.cache.deleteFromCache(t);
    }

    private final void addCurrentText() {
        this.addToCache(this.text.getText());
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addValueListener(l);
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.supp.rmValueListener(l);
    }

    @Override
    public final synchronized void setValue(String val) {
        if (this.cacheLoading) {
            this.objToSelect = val;
        }
        this.text.setText(val);
    }

    @Override
    public void resetValue() {
        this.setValue(null);
    }

    @Override
    public String getValue() {
        return this.text.getText();
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    @Override
    public boolean isValidated() {
        return true;
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.supp.addValidListener(l);
    }

    @Override
    public void removeValidListener(ValidListener l) {
        this.supp.removeValidListener(l);
    }

    @Override
    public Document getDocument() {
        if (this.isLocked()) {
            return null;
        }
        return this.text.getDocument();
    }

    @Override
    public String getValidationText() {
        return null;
    }

    private synchronized void updateAutoCompletion(boolean showAll) {
        if (!this.isCompletionEnabled() || this.cacheLoading || this.cache == null) {
            return;
        }
        String t = this.text.getText();
        System.out.println("Update:" + t);
        if (this.th != null) {
            this.th.stopNow();
        }
        this.th = new ITextSelectorCompletionThread(this, showAll, t);
        this.th.setPriority(1);
        this.th.start();
    }

    boolean isCompletionEnabled() {
        return this.completionEnabled;
    }

    void setCompletionEnabled(boolean completionEnabled) {
        this.completionEnabled = completionEnabled;
    }

    void hideCompletionPopup() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ITextSelector.this.popupCompletion.setVisible(false);
            }
        });
    }

    synchronized void showCompletionPopup() {
        if (this.model.size() > 0 && this.text.isShowing()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!ITextSelector.this.popupCompletion.isShowing()) {
                        ITextSelector.this.popupCompletion.show(ITextSelector.this, 0, ITextSelector.this.getBounds().height);
                    }
                }
            });
        }
    }

    public void setTextEditor(JTextComponent atext) {
        if (atext == null) {
            throw new IllegalArgumentException("null textEditor");
        }
        this.text = atext;
        atext.getDocument().addDocumentListener(this);
        atext.addKeyListener(new KeyListener(){
            private boolean consume;

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40) {
                    if (ITextSelector.this.popupCompletion.isShowing()) {
                        ITextSelector.this.popupCompletion.selectNext();
                        e.consume();
                    } else {
                        ITextSelector.this.showCompletionPopup();
                    }
                } else if (e.getKeyCode() == 38) {
                    if (ITextSelector.this.popupCompletion.isShowing()) {
                        ITextSelector.this.popupCompletion.selectPrevious();
                        e.consume();
                    }
                } else if (e.getKeyCode() == 10) {
                    if (ITextSelector.this.popupCompletion.isShowing()) {
                        ITextSelector.this.popupCompletion.validateSelection();
                        ITextSelector.this.hideCompletionPopup();
                        e.consume();
                    }
                } else if (e.getKeyCode() == 34) {
                    if (ITextSelector.this.popupCompletion.isShowing()) {
                        ITextSelector.this.popupCompletion.selectNextPage();
                        e.consume();
                    }
                } else if (e.getKeyCode() == 33 && ITextSelector.this.popupCompletion.isShowing()) {
                    ITextSelector.this.popupCompletion.selectPreviousPage();
                    e.consume();
                }
                if (ITextSelector.this.text.getDocument().getLength() == 0 && (e.getKeyCode() == 127 || e.getKeyCode() == 8)) {
                    this.consume = true;
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (this.consume) {
                    e.consume();
                    this.consume = false;
                }
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                ITextSelector.this.popupCompletion.setMinWith(ITextSelector.this.getBounds().width);
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        this.text.addMouseListener(this.mouseListener);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateAutoCompletion(false);
        this.supp.fireValueChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateAutoCompletion(false);
        this.supp.fireValueChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateAutoCompletion(false);
        this.supp.fireValueChange();
    }

    public void setMinimumSearch(int j) {
        this.minimumSearch = j;
    }

    public int getMinimumSearch() {
        return this.minimumSearch;
    }

    public void setMaximumResult(int j) {
        this.maximumResult = j;
    }

    public List<String> getCache() {
        return this.cache.getCache();
    }

    public int getCompletionMode() {
        return 2;
    }

    public int getMaximumResult() {
        return this.maximumResult;
    }

    @Override
    public JTextComponent getTextComp() {
        return this.text;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setEditable(enabled);
        this.text.setEnabled(enabled);
        this.i = enabled ? imageSelectorEnabled : imageSelectorDisabled;
        this.text.removeMouseListener(this.mouseListener);
        if (enabled) {
            this.text.addMouseListener(this.mouseListener);
        }
    }

    @Override
    public String toString() {
        return "ITextSelector:" + this.text.getText();
    }
}

