/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component;

import java.awt.Desktop;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openconcerto.utils.ExceptionHandler;

public class HTMLTextField
extends JEditorPane {
    public HTMLTextField(String html) {
        super("text/html", html);
        this.setEditable(false);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                JComponent src = (JComponent)e.getSource();
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HTMLTextField.this.linkActivated(e, src);
                } else if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    src.setToolTipText(HTMLTextField.this.getToolTip(e));
                } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    src.setToolTipText(null);
                }
            }
        });
        this.setBorder(null);
        this.setOpaque(false);
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.setFont(new JTextField().getFont());
    }

    protected String getToolTip(HyperlinkEvent e) {
        return e.getDescription();
    }

    protected void linkActivated(HyperlinkEvent e, JComponent src) {
        try {
            Desktop.getDesktop().browse(e.getURL().toURI());
        }
        catch (Exception exn) {
            ExceptionHandler.handle(src, "Impossible d'ouvrir " + e.getURL(), exn);
        }
    }
}

