/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.io.File;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Formatter;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.component.HTMLTextField;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;

public class SystemInfoPanel
extends JPanel {
    public SystemInfoPanel() {
        FormLayouter l = new FormLayouter(this, 1);
        String version = System.getProperty("java.runtime.version") != null ? System.getProperty("java.runtime.version") : System.getProperty("java.version");
        URI vendorURI = null;
        try {
            vendorURI = new URI(System.getProperty("java.vendor.url"));
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        Runtime rt = Runtime.getRuntime();
        String stats = "<i>m\u00e9moire :</i> " + SystemInfoPanel.formatBytes(rt.freeMemory()) + " / " + SystemInfoPanel.formatBytes(rt.totalMemory()) + " ; " + rt.availableProcessors() + " processeur(s)";
        HTMLTextField p = new HTMLTextField("Version <b>" + version + "</b> de " + SystemInfoPanel.getLink(System.getProperty("java.vendor"), vendorURI) + " ; " + SystemInfoPanel.getLink("dossier d'installation", new File(System.getProperty("java.home")).toURI()) + "<br>" + stats);
        l.add("Java", p);
        l.add("Syst\u00e8me d'exploitation", new JLabel("<html><b>" + System.getProperty("os.name") + "</b> " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")</html>"));
        HTMLTextField userPane = new HTMLTextField(String.valueOf(System.getProperty("user.name")) + " ; " + SystemInfoPanel.getLink("dossier utilisateur", new File(System.getProperty("user.home")).toURI()) + " ; " + SystemInfoPanel.getLink("dossier courant", new File(System.getProperty("user.dir")).toURI()));
        l.add("Utilisateur", userPane);
        ArrayList<String> ifs = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface ni = en.nextElement();
                if (ni.getHardwareAddress() == null || ni.isLoopback() || ni.getDisplayName().toLowerCase().contains("vmware") || ni.getName().toLowerCase().contains("vmnet")) continue;
                StringBuilder sb = new StringBuilder();
                sb.append(String.valueOf(ni.getName()) + " " + CollectionUtils.join(ni.getInterfaceAddresses(), ", ", new ITransformer<InterfaceAddress, String>(){

                    @Override
                    public String transformChecked(InterfaceAddress input) {
                        return "<b>" + input.getAddress().getHostAddress() + "</b>" + "/" + input.getNetworkPrefixLength();
                    }
                }));
                sb.append(" ; <i>\u00e9tat :</i> " + (ni.isUp() ? "actif" : "inactif"));
                sb.append("<br> <i>nom complet :</i> " + ni.getDisplayName());
                sb.append("<br> <i>adresse mat\u00e9rielle :</i> ");
                Formatter fmt = new Formatter(sb);
                byte[] mac = ni.getHardwareAddress();
                int i = 0;
                while (i < mac.length) {
                    fmt.format("%02X%s", mac[i], i < mac.length - 1 ? ":" : "");
                    ++i;
                }
                ifs.add(sb.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ifs.add(e.getLocalizedMessage());
        }
        l.add("R\u00e9seau", new HTMLTextField(CollectionUtils.join(ifs, "<br>")));
    }

    private static final String getLink(String name, URI uri) {
        return uri == null ? name : "<a href=\"" + uri.toString() + "\" >" + name + "</a>";
    }

    private static String formatBytes(long b) {
        return String.valueOf(b / 1024L / 1024L) + "Mo";
    }
}

