/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.calendar.JXMonthView;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.checks.ValidListener;

public final class JDate
extends JXDatePicker
implements ValueWrapper<Date>,
TextComponent {
    private final boolean fillWithCurrentDate;

    public JDate() {
        this(false);
    }

    public JDate(boolean fillWithCurrentDate) {
        this.fillWithCurrentDate = fillWithCurrentDate;
        this.setFormats(new String[]{"dd/MM/yy", "d MMMM yyyy"});
        JXMonthView monthView = new JXMonthView();
        monthView.setFirstDayOfWeek(Calendar.getInstance().getFirstDayOfWeek());
        monthView.setTraversable(true);
        this.setMonthView(monthView);
        this.resetValue();
    }

    @Override
    public final void resetValue() {
        if (this.fillWithCurrentDate) {
            this.setValue(new Date());
        } else {
            this.setValue(null);
        }
    }

    @Override
    public final void setValue(Date date) {
        this.setDate(date);
    }

    @Override
    public final Date getValue() {
        return this.getDate();
    }

    public final boolean isEmpty() {
        return this.getValue() == null;
    }

    @Override
    public final void addValueListener(PropertyChangeListener l) {
        this.getEditor().addPropertyChangeListener("value", l);
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.getEditor().removePropertyChangeListener("value", l);
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    @Override
    public boolean isValidated() {
        return true;
    }

    @Override
    public void addValidListener(ValidListener l) {
    }

    @Override
    public void removeValidListener(ValidListener l) {
    }

    @Override
    public String getValidationText() {
        return null;
    }

    @Override
    public JTextComponent getTextComp() {
        return this.getEditor();
    }
}

