/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.io.File;
import java.io.IOException;
import org.openconcerto.ui.preferences.EmailProps;
import org.openconcerto.utils.EmailClient;

public class EmailComposer {
    private static EmailComposer instance = new EmailComposer();

    public static synchronized EmailComposer getInstance() {
        return instance;
    }

    public void compose(String to, String subject, String text, File attachedFile) throws IOException, InterruptedException {
        EmailClient emailClient;
        if (to == null) {
            to = "";
        }
        if (subject == null) {
            subject = "";
        }
        if (text == null) {
            text = "";
        }
        to = to.trim();
        subject = subject.trim();
        text = text.trim();
        int mode = EmailProps.getInstance().getMode();
        if (mode == 1) {
            String app = EmailProps.getInstance().getThunderbirdPath();
            emailClient = EmailClient.Thunderbird.createFromExe(new File(app));
        } else {
            emailClient = mode == 2 ? EmailClient.Outlook : EmailClient.getPreferred();
        }
        emailClient.compose(to, subject, text, attachedFile);
    }
}

