/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.task;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.User;

public class UserTaskRight {
    private int idUser;
    private int idToUser;
    private boolean canRead;
    private boolean canModify;
    private boolean canAdd;
    private boolean canValidate;

    public UserTaskRight(int idUser, int idToUser, boolean canRead, boolean canModify, boolean canAdd, boolean canValidate) {
        this.idUser = idUser;
        this.idToUser = idToUser;
        this.canRead = canRead;
        this.canModify = canModify;
        this.canAdd = canAdd;
        this.canValidate = canValidate;
    }

    public boolean canModify() {
        return this.canModify;
    }

    public boolean canRead() {
        return this.canRead;
    }

    public boolean canValidate() {
        return this.canValidate;
    }

    public boolean canAdd() {
        return this.canAdd;
    }

    public int getIdToUser() {
        return this.idToUser;
    }

    public int getIdUser() {
        return this.idUser;
    }

    public static List<UserTaskRight> getUserTaskRight(final User selectedUser) {
        SQLTable rightsT = Configuration.getInstance().getSystemRoot().findTable("TACHE_RIGHTS", true);
        final SQLField userF = rightsT.getField("ID_USER_COMMON");
        final SQLTable userT = rightsT.getForeignTable(userF.getName());
        SQLSelect sel = new SQLSelect(rightsT.getBase());
        sel.addSelectStar(rightsT);
        sel.setWhere(new Where((FieldRef)userF, "=", selectedUser.getId()));
        String req = sel.toString();
        SQLDataSource dataSource = Configuration.getInstance().getBase().getDataSource();
        List l = (List)dataSource.execute(req, new ResultSetHandler(){

            @Override
            public Object handle(ResultSet rs) throws SQLException {
                Vector<UserTaskRight> list = new Vector<UserTaskRight>();
                list.add(new UserTaskRight(selectedUser.getId(), selectedUser.getId(), true, true, true, true));
                while (rs.next()) {
                    int idUser = rs.getInt(userF.getName());
                    if (!$assertionsDisabled && idUser != selectedUser.getId()) {
                        throw new AssertionError();
                    }
                    int idToUser = rs.getInt("ID_USER_COMMON_TO");
                    boolean canRead = rs.getBoolean("READ");
                    boolean canModify = rs.getBoolean("MODIFY");
                    boolean canWrite = rs.getBoolean("ADD");
                    boolean canValidate = rs.getBoolean("VALIDATE");
                    if (idToUser == userT.getUndefinedID() || idToUser == idUser) continue;
                    list.add(new UserTaskRight(idUser, idToUser, canRead, canModify, canWrite, canValidate));
                }
                return list;
            }
        });
        return l;
    }

    public String toString() {
        return "UserTaskRight:" + this.idUser + " to user:" + this.idToUser + "Read:" + this.canRead + " Modify:" + this.canModify + " Add:" + this.canAdd + " Validate:" + this.canValidate;
    }
}

