/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.listview;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.view.listview.ItemPoolFactory;
import org.openconcerto.sql.view.listview.ListSQLView;
import org.openconcerto.utils.checks.ValidListener;

public abstract class ItemPool {
    private final ItemPoolFactory creator;
    private final ListSQLView panel;
    private final Set<ValidListener> validListeners;

    public ItemPool(ItemPoolFactory parent, ListSQLView panel) {
        this.creator = parent;
        this.panel = panel;
        this.validListeners = new HashSet<ValidListener>();
    }

    public abstract void reset();

    public abstract void show(SQLRowAccessor var1);

    public abstract boolean availableItem();

    public abstract SQLRowItemView getNewItem() throws IllegalStateException;

    public abstract void removeItem(SQLRowItemView var1);

    public abstract List<SQLRowItemView> getItems();

    public abstract List<SQLRowItemView> getAddedItems();

    public abstract List<SQLRowItemView> getRemovedItems();

    protected final ItemPoolFactory getCreator() {
        return this.creator;
    }

    protected final ListSQLView getPanel() {
        return this.panel;
    }

    public abstract void update(SQLRowValues var1);

    public abstract void insert(SQLRowValues var1);

    protected final void forAllDo(Collection c, Closure cl) {
        CollectionUtils.forAllDo(c, cl);
    }

    public final void addValidListener(ValidListener l) {
        this.validListeners.add(l);
    }

    public void removeValidListener(ValidListener l) {
        this.validListeners.remove(l);
    }

    protected final synchronized void fireValidChange() {
        boolean validated = this.isValidated();
        for (ValidListener l : this.validListeners) {
            l.validChange(this.getPanel(), validated);
        }
    }

    final boolean isValidated() {
        boolean res = true;
        Iterator<SQLRowItemView> iter = this.getItems().iterator();
        while (iter.hasNext() && res) {
            SQLRowItemView v = iter.next();
            res = v.isValidated();
        }
        return res;
    }

    protected static abstract class Cl
    implements Closure {
        protected Cl() {
        }

        public abstract void execute(SQLRowItemView var1);

        @Override
        public final void execute(Object input) {
            this.execute((SQLRowItemView)input);
        }
    }
}

