/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list.search;

import java.util.Collections;
import java.util.List;
import org.openconcerto.sql.view.list.ListAccess;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.search.SearchQueue;
import org.openconcerto.sql.view.search.SearchSpec;

abstract class SearchRunnable
implements Runnable {
    private final SearchQueue q;

    public SearchRunnable(SearchQueue q) {
        this.q = q;
    }

    protected final boolean isFiltered() {
        return this.getSearch() != null && !this.getSearch().isEmpty();
    }

    protected final boolean matchFilter(ListSQLLine line) {
        if (this.isFiltered()) {
            return this.matchFilterUnsafe(line);
        }
        return true;
    }

    protected final boolean matchFilterUnsafe(ListSQLLine line) {
        int columnCount = this.q.getModel().getColumnCount();
        return this.getSearch().match(line.getList(columnCount).subList(0, columnCount));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " on " + this.q;
    }

    protected final ListAccess getAccess() {
        return this.q.getAccess();
    }

    protected final SearchSpec getSearch() {
        return this.q.getSearch();
    }

    protected final List<ListSQLLine> getFullList() {
        return Collections.unmodifiableList(this.q.getFullList());
    }
}

