/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.utils.OrderedSet;

public class RowValuesTableModel
extends AbstractTableModel {
    private Vector<SQLRowValues> rowValues = new Vector();
    private OrderedSet<TableModelListener> tableModelListeners = new OrderedSet();
    protected SQLElement element;
    private int nbColumn;
    private List<SQLTableElement> list;
    Map<String, Integer> mapColumnField = new HashMap<String, Integer>();
    private SQLField requiredField;
    private SQLField validationField;
    SQLRowValues rowParDefaut;
    private Vector<SQLRowValues> rowValuesDeleted = new Vector();
    private boolean editable = true;
    protected static final ExecutorService runnableQueue = new ThreadPoolExecutor(0, 1, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    public RowValuesTableModel() {
    }

    public RowValuesTableModel(SQLElement e, List<SQLTableElement> list, SQLField validField) {
        this(e, list, validField, true);
    }

    public RowValuesTableModel(SQLElement e, List<SQLTableElement> list, SQLField validField, boolean addDefault, SQLRowValues rowParDefaut) {
        this(e, list, validField, addDefault, rowParDefaut, null);
    }

    public RowValuesTableModel(SQLElement e, List<SQLTableElement> list, SQLField validField, boolean addDefault, SQLRowValues rowParDefaut, SQLField validationField) {
        this.init(e, list, validField, addDefault, rowParDefaut, validationField);
    }

    public RowValuesTableModel(SQLElement e, List<SQLTableElement> list, SQLField validField, boolean addDefault) {
        this(e, list, validField, addDefault, null);
    }

    protected void init(SQLElement e, List<SQLTableElement> list, SQLField validField, boolean addDefault, SQLRowValues rowParDefaut) {
        this.init(e, list, validField, addDefault, rowParDefaut, null);
    }

    protected void init(SQLElement e, List<SQLTableElement> list, SQLField validField, boolean addDefault, SQLRowValues rowParDefaut, SQLField validationField) {
        this.element = e;
        this.requiredField = validField;
        this.validationField = validationField;
        this.list = list;
        this.nbColumn = list.size();
        this.rowParDefaut = rowParDefaut != null ? rowParDefaut : UndefinedRowValuesCache.getInstance().getDefaultRowValues(e.getTable());
        if (addDefault) {
            this.addRow(new SQLRowValues(this.rowParDefaut));
        }
    }

    public synchronized void addColumn(SQLTableElement e) {
        ++this.nbColumn;
        this.list.add(e);
    }

    @Override
    public synchronized int getColumnCount() {
        return this.nbColumn;
    }

    @Override
    public int getRowCount() {
        return this.rowValues.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.editable) {
            return false;
        }
        SQLTableElement elt = this.list.get(columnIndex);
        boolean validate = false;
        boolean fieldValidate = false;
        if (this.validationField != null) {
            fieldValidate = elt.getField().getName().equalsIgnoreCase(this.validationField.getName());
            validate = this.getRowValuesAt(rowIndex).getBoolean(this.validationField.getName());
        }
        if (validate && fieldValidate) {
            return this.list.get(columnIndex).isCellEditable(this.getRowValuesAt(rowIndex));
        }
        return !validate && this.list.get(columnIndex).isCellEditable(this.getRowValuesAt(rowIndex));
    }

    @Override
    public synchronized Class<?> getColumnClass(int columnIndex) {
        return this.list.get(columnIndex).getElementClass();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        if (rowIndex >= this.rowValues.size()) {
            Thread.dumpStack();
            return new Integer(0);
        }
        SQLRowValues val = this.rowValues.get(rowIndex);
        SQLTableElement sqlTableElem = this.list.get(columnIndex);
        result = sqlTableElem.getValueFrom(val);
        return result;
    }

    public void putValue(Object value, int rowIndex, String fieldName) {
        SQLRowValues rowVal = this.rowValues.get(rowIndex);
        rowVal.put(fieldName, value);
        for (SQLTableElement sqlTableElem : this.list) {
            sqlTableElem.fireModification(rowVal);
        }
        this.fireTableModelModified(rowIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        SQLRowValues rowVal;
        if (!this.editable) {
            return;
        }
        SQLTableElement sqlTableElem = this.list.get(columnIndex);
        Object realVal = sqlTableElem.convertEditorValueToModel(aValue, rowVal = this.rowValues.get(rowIndex));
        if (realVal == null || realVal.getClass() == this.getColumnClass(columnIndex)) {
            sqlTableElem.setValueFrom(rowVal, realVal);
            this.fireTableModelModified(rowIndex);
            this.fireTableChanged(new TableModelEvent(this, rowIndex, rowIndex, columnIndex));
        } else {
            Thread.dumpStack();
        }
    }

    private void dumpValues() {
        int i = 0;
        while (i < this.rowValues.size()) {
            SQLRowValues val = this.rowValues.get(i);
            System.out.println("Item" + i + ":" + val);
            ++i;
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        SQLTableElement sqlTableElem = this.list.get(columnIndex);
        return sqlTableElem.getColumnName();
    }

    public void commitData() {
        try {
            int i = 0;
            while (i < this.rowValues.size()) {
                SQLRowValues r = this.rowValues.get(i);
                SQLRow row = r.commit();
                r.setID(row.getIDNumber());
                ++i;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.tableModelListeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.tableModelListeners.remove(l);
    }

    public void fireTableModelModified(int line) {
        this.fireTableRowsUpdated(line, line);
    }

    public int getColumnForField(String to) {
        if (this.mapColumnField.get(to) == null) {
            int columnIndex = 0;
            while (columnIndex < this.list.size()) {
                SQLTableElement sqlTableElem = this.list.get(columnIndex);
                if (sqlTableElem.getField() != null && sqlTableElem.getField().getName().equalsIgnoreCase(to)) {
                    this.mapColumnField.put(to, columnIndex);
                    return columnIndex;
                }
                ++columnIndex;
            }
            this.mapColumnField.put(to, -1);
            return -1;
        }
        return this.mapColumnField.get(to);
    }

    public synchronized void addNewRowAt(final int index) {
        runnableQueue.submit(new Runnable(){

            @Override
            public void run() {
                Number n;
                String orderField;
                SQLRowValues vals;
                int realIndex = index;
                if (realIndex < 0) {
                    realIndex = 0;
                }
                SQLRowValues newRowParDefaut = new SQLRowValues(RowValuesTableModel.this.rowParDefaut);
                if (realIndex < RowValuesTableModel.this.getRowCount()) {
                    if (realIndex > 0) {
                        SQLRowValues vals1 = (SQLRowValues)RowValuesTableModel.this.rowValues.get(realIndex - 1);
                        SQLRowValues vals2 = (SQLRowValues)RowValuesTableModel.this.rowValues.get(realIndex);
                        String orderField2 = vals1.getTable().getOrderField().getName();
                        Number n1 = (Number)vals1.getObject(orderField2);
                        Number n2 = (Number)vals2.getObject(orderField2);
                        if (n1 != null && n2 != null) {
                            double tmp = n2.doubleValue() - n1.doubleValue();
                            newRowParDefaut.put(orderField2, BigDecimal.valueOf(n1.doubleValue() + tmp / 2.0));
                        } else if (n1 != null) {
                            newRowParDefaut.put(orderField2, BigDecimal.valueOf(n1.doubleValue() + 0.1));
                        }
                    } else {
                        vals = (SQLRowValues)RowValuesTableModel.this.rowValues.get(realIndex);
                        n = (Number)vals.getObject(orderField = vals.getTable().getOrderField().getName());
                        if (n != null) {
                            newRowParDefaut.put(orderField, BigDecimal.valueOf(n.doubleValue() - 0.1));
                        } else {
                            newRowParDefaut.put(orderField, BigDecimal.valueOf(vals.getTable().getMaxOrder().doubleValue() + 0.1));
                        }
                    }
                } else if (RowValuesTableModel.this.getRowCount() > 0) {
                    vals = (SQLRowValues)RowValuesTableModel.this.rowValues.get(realIndex - 1);
                    n = (Number)vals.getObject(orderField = vals.getTable().getOrderField().getName());
                    if (n != null) {
                        newRowParDefaut.put(orderField, BigDecimal.valueOf(n.doubleValue() + 1.0));
                    }
                } else {
                    newRowParDefaut.put(newRowParDefaut.getTable().getOrderField().getName(), newRowParDefaut.getTable().getMaxOrder().doubleValue() + 1.0);
                }
                RowValuesTableModel.this.rowValues.add(realIndex, newRowParDefaut);
                final int fireIndex = realIndex;
                int i = 0;
                while (i < RowValuesTableModel.this.tableModelListeners.size()) {
                    final TableModelListener l = (TableModelListener)RowValuesTableModel.this.tableModelListeners.get(i);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            l.tableChanged(new TableModelEvent(RowValuesTableModel.this, fireIndex, fireIndex, -1, 1));
                        }
                    });
                    ++i;
                }
            }
        });
    }

    public synchronized void removeRowAt(final int index) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Thread.dumpStack();
        }
        if (index < 0) {
            return;
        }
        runnableQueue.submit(new Runnable(){

            @Override
            public void run() {
                RowValuesTableModel.this.rowValuesDeleted.add((SQLRowValues)RowValuesTableModel.this.rowValues.remove(index));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RowValuesTableModel.this.fireTableRowsDeleted(index, index);
                    }
                });
            }
        });
    }

    public synchronized void removeRowsAt(final int[] index) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Thread.dumpStack();
        }
        if (index.length <= 0) {
            return;
        }
        runnableQueue.submit(new Runnable(){

            @Override
            public void run() {
                ArrayList<SQLRowValues> rowVals = new ArrayList<SQLRowValues>(index.length);
                int[] nArray = index;
                int n = index.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    SQLRowValues rowValues2 = (SQLRowValues)RowValuesTableModel.this.rowValues.get(i);
                    rowVals.add(rowValues2);
                    RowValuesTableModel.this.rowValuesDeleted.add(rowValues2);
                    ++n2;
                }
                RowValuesTableModel.this.rowValues.removeAll(rowVals);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RowValuesTableModel.this.fireTableDataChanged();
                    }
                });
            }
        });
    }

    public synchronized void addNewRow() {
        this.addNewRowAt(this.getRowCount());
    }

    public boolean isLastRowValid() {
        return this.isRowValid(this.rowValues.size() - 1);
    }

    public boolean isRowValid(int index) {
        if (this.rowValues.size() == 0) {
            return true;
        }
        if (index < 0 || index >= this.rowValues.size()) {
            return false;
        }
        SQLRowValues row = this.rowValues.get(index);
        if (this.requiredField.isKey()) {
            SQLRowAccessor rowAccess = row.getForeign(this.requiredField.getName());
            return rowAccess != null && rowAccess.getID() > rowAccess.getTable().getUndefinedID();
        }
        Object object = row.getObject(this.requiredField.getName());
        return object != null && object.toString().trim().length() > 0;
    }

    public boolean isValidated() {
        boolean b = true;
        int i = 0;
        while (i < this.getRowCount()) {
            b &= this.isRowValid(i);
            ++i;
        }
        return b;
    }

    public final List<SQLTableElement> getList() {
        return this.list;
    }

    public void updateField(String field, SQLRowValues rowVals, String fieldCondition) {
        if (rowVals != null) {
            int stop = this.rowValues.size();
            if (!this.isLastRowValid()) {
                --stop;
            }
            int id = rowVals.getID();
            int i = 0;
            while (i < stop) {
                SQLRowValues r = this.rowValues.get(i);
                if (fieldCondition != null) {
                    Object o = r.getObject(fieldCondition);
                    if (o != null && ((Boolean)o).booleanValue()) {
                        if (id != -1) {
                            r.put(field, id);
                        } else {
                            r.put(field, rowVals);
                        }
                    } else {
                        r.put(field, 1);
                    }
                } else if (id != -1) {
                    r.put(field, id);
                } else {
                    r.put(field, rowVals);
                }
                ++i;
            }
            ArrayList<SQLRowValues> l = new ArrayList<SQLRowValues>(this.rowValuesDeleted);
            int i2 = 0;
            while (i2 < l.size()) {
                SQLRowValues rowVals2 = (SQLRowValues)l.get(i2);
                int idRow = rowVals2.getID();
                if (idRow != -1) {
                    try {
                        this.element.archive(idRow);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                } else {
                    rowVals2.putEmptyLink(field);
                }
                ++i2;
            }
            this.rowValuesDeleted.removeAllElements();
            if (id != -1) {
                this.commitData();
            }
        }
    }

    public void updateField(String field, SQLRowValues rowVals) {
        this.updateField(field, rowVals, null);
    }

    public void updateField(String field, int id) {
        this.updateField(field, id, null);
    }

    public void updateField(String field, int id, String fieldCondition) {
        if (id > 0) {
            this.updateField(field, this.element.getTable().getForeignTable(field).getRow(id).createUpdateRow(), fieldCondition);
        }
    }

    public void insertFrom(String field, int id) {
        this.insertFrom(field, id, -1);
    }

    public void insertFrom(final String field, final int id, final int exceptID) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Thread.dumpStack();
        }
        if (id > 0) {
            runnableQueue.submit(new Runnable(){

                @Override
                public void run() {
                    RowValuesTableModel.this.rowValues.clear();
                    SQLSelect sel = new SQLSelect(Configuration.getInstance().getBase());
                    sel.addSelect(RowValuesTableModel.this.element.getTable().getKey());
                    Where w = new Where((FieldRef)RowValuesTableModel.this.element.getTable().getField(field), "=", id);
                    w = w.and(new Where((FieldRef)RowValuesTableModel.this.element.getTable().getKey(), "!=", exceptID));
                    sel.setWhere(w);
                    sel.addFieldOrder(RowValuesTableModel.this.element.getTable().getOrderField());
                    String req = sel.asString();
                    List l = RowValuesTableModel.this.element.getTable().getBase().getDataSource().execute(req);
                    int i = 0;
                    while (i < l.size()) {
                        Map m = (Map)l.get(i);
                        Number idItem = (Number)m.get(RowValuesTableModel.this.element.getTable().getKey().getName());
                        SQLRow sqlrow = RowValuesTableModel.this.element.getTable().getRow(idItem.intValue());
                        SQLRowValues row = sqlrow.createUpdateRow();
                        RowValuesTableModel.this.rowValues.add(row);
                        ++i;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RowValuesTableModel.this.fireTableModelModified(RowValuesTableModel.this.rowValues.size());
                        }
                    });
                }
            });
        }
    }

    public void insertFrom(String field, final SQLRowValues rowVals) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Thread.dumpStack();
        }
        if (rowVals != null) {
            runnableQueue.submit(new Runnable(){

                @Override
                public void run() {
                    RowValuesTableModel.this.rowValues.clear();
                    if (rowVals.getID() > 1) {
                        SQLRow row = rowVals.getTable().getRow(rowVals.getID());
                        Collection rowSet = row.getReferentRows(RowValuesTableModel.this.element.getTable());
                        for (SQLRow row2 : rowSet) {
                            SQLRowValues rowVals2 = new SQLRowValues(RowValuesTableModel.this.element.getTable());
                            rowVals2.loadAbsolutelyAll(row2);
                            RowValuesTableModel.this.rowValues.add(rowVals2);
                        }
                    } else {
                        Collection<SQLRowValues> colRows = rowVals.getReferentRows();
                        for (SQLRowValues rowValues : colRows) {
                            if (!rowValues.getTable().getName().equalsIgnoreCase(RowValuesTableModel.this.element.getTable().getName())) continue;
                            RowValuesTableModel.this.rowValues.add(rowValues);
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RowValuesTableModel.this.fireTableModelModified(RowValuesTableModel.this.rowValues.size());
                        }
                    });
                }
            });
        }
    }

    public void addRow(SQLRowValues row) {
        this.addRow(row, true);
    }

    public void addRow(final SQLRowValues row, final boolean fireModified) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Thread.dumpStack();
        }
        runnableQueue.submit(new Runnable(){

            @Override
            public void run() {
                BigDecimal maxOrder = RowValuesTableModel.this.element.getTable().getMaxOrder();
                BigDecimal valueOf = BigDecimal.valueOf(maxOrder.doubleValue() + (double)RowValuesTableModel.this.rowValues.size() + 1.0);
                row.put(RowValuesTableModel.this.element.getTable().getOrderField().getName(), valueOf);
                RowValuesTableModel.this.rowValues.add(row);
                if (fireModified) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (SQLTableElement sqlTableElem : RowValuesTableModel.this.list) {
                                sqlTableElem.fireModification(row);
                            }
                            RowValuesTableModel.this.fireTableRowsInserted(RowValuesTableModel.this.rowValues.size() - 1, RowValuesTableModel.this.rowValues.size() - 1);
                        }
                    });
                }
            }
        });
    }

    public void clearRows() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Thread.dumpStack();
        }
        runnableQueue.submit(new Runnable(){

            @Override
            public void run() {
                final int size = RowValuesTableModel.this.rowValues.size();
                if (size > 0) {
                    RowValuesTableModel.this.rowValues.clear();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RowValuesTableModel.this.fireTableRowsDeleted(0, size - 1);
                        }
                    });
                }
            }
        });
    }

    public SQLTableElement getSQLTableElementAt(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.list.size()) {
            return this.list.get(columnIndex);
        }
        return null;
    }

    public int getColumnIndexForElement(SQLTableElement e) {
        int columnIndex = 0;
        while (columnIndex < this.list.size()) {
            SQLTableElement sqlTableElem = this.list.get(columnIndex);
            if (sqlTableElem.equals(e)) {
                return columnIndex;
            }
            ++columnIndex;
        }
        return -1;
    }

    public SQLRowValues getRowValuesAt(int rowIndex) {
        return this.rowValues.get(rowIndex);
    }

    public final int id2index(int id) {
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.getRowValuesAt(i).getID() == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void fireTableChanged(TableModelEvent event) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Thread.dumpStack();
        }
        int i = 0;
        while (i < this.tableModelListeners.size()) {
            TableModelListener l = (TableModelListener)this.tableModelListeners.get(i);
            l.tableChanged(event);
            ++i;
        }
    }

    @Override
    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    @Override
    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    @Override
    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    @Override
    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    @Override
    public void fireTableCellUpdated(int row, int column) {
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
    }

    public int moveBy(int rowIndex, int inc) {
        int destIndex = rowIndex + inc;
        if (rowIndex >= 0 && destIndex >= 0 && rowIndex < this.rowValues.size() && destIndex < this.rowValues.size()) {
            SQLRowValues rowValues1 = this.rowValues.get(rowIndex);
            SQLRowValues rowValues2 = this.rowValues.get(destIndex);
            this.rowValues.set(rowIndex, rowValues2);
            this.rowValues.set(destIndex, rowValues1);
            Object ordre1 = rowValues1.getObject(rowValues1.getTable().getOrderField().getName());
            Object ordre2 = rowValues2.getObject(rowValues2.getTable().getOrderField().getName());
            rowValues1.put(rowValues1.getTable().getOrderField().getName(), ordre2);
            rowValues2.put(rowValues1.getTable().getOrderField().getName(), ordre1);
            this.fireTableRowsUpdated(rowIndex, destIndex);
            this.fireTableDataChanged();
        }
        return destIndex;
    }

    public void setEditable(boolean b, int column) {
        this.list.get(column).setEditable(b);
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    public SQLElement getSQLElement() {
        return this.element;
    }

    public SQLField getRequiredField() {
        return this.requiredField;
    }
}

