/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JComponentUtils;

public class RowValuesTableControlPanel
extends JPanel
implements MouseListener {
    private final RowValuesTable table;
    private final RowValuesTableModel model;
    JButton buttonBas;
    JButton buttonHaut;
    JButton buttonAjouter;
    JButton buttonInserer;
    JButton buttonClone;
    JButton buttonSuppr;
    private static String MSG = "S\u00e9lectionnez d'abord une ligne";

    public RowValuesTableControlPanel(RowValuesTable table) {
        this(table, null);
    }

    public void setEditable(boolean b) {
        this.buttonAjouter.setEnabled(b);
        this.buttonHaut.setEnabled(b);
        this.buttonInserer.setEnabled(b);
        this.buttonClone.setEnabled(b);
        this.buttonBas.setEnabled(b);
        this.buttonSuppr.setEnabled(b);
    }

    public RowValuesTableControlPanel(final RowValuesTable table, final List<JButton> l) {
        super(new GridBagLayout());
        this.model = table.getRowValuesTableModel();
        if (table == null) {
            throw new IllegalArgumentException("RowValuesTable null");
        }
        if (this.model == null) {
            throw new IllegalArgumentException("RowValuesTableModel null");
        }
        this.table = table;
        this.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.buttonHaut = new JButton(new ImageIcon(IListFrame.class.getResource("fleche_haut.png")));
        this.buttonHaut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RowValuesTableControlPanel.this.deplacerDe(-1);
            }
        });
        this.add((Component)this.buttonHaut, c);
        this.buttonHaut.setEnabled(false);
        this.buttonBas = new JButton(new ImageIcon(IListFrame.class.getResource("fleche_bas.png")));
        this.buttonBas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RowValuesTableControlPanel.this.deplacerDe(1);
            }
        });
        ++c.gridx;
        this.add((Component)this.buttonBas, c);
        this.buttonBas.setEnabled(false);
        this.buttonAjouter = new JButton("Ajouter une ligne");
        this.buttonAjouter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RowValuesTableControlPanel.this.model.addNewRowAt(table.getRowCount());
            }
        });
        ++c.gridx;
        JComponentUtils.setMinimumWidth(this.buttonAjouter, 88);
        this.add((Component)this.buttonAjouter, c);
        this.buttonInserer = new JButton("Ins\u00e9rer une ligne");
        this.buttonInserer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RowValuesTableControlPanel.this.model.addNewRowAt(table.getSelectedRow());
            }
        });
        this.buttonInserer.setEnabled(false);
        ++c.gridx;
        JComponentUtils.setMinimumWidth(this.buttonInserer, 85);
        this.add((Component)this.buttonInserer, c);
        this.buttonClone = new JButton("Dupliquer une ligne");
        this.buttonClone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RowValuesTableControlPanel.this.cloneLine(table.getSelectedRow());
            }
        });
        this.buttonClone.setEnabled(false);
        ++c.gridx;
        JComponentUtils.setMinimumWidth(this.buttonClone, 95);
        this.add((Component)this.buttonClone, c);
        this.buttonSuppr = new JButton("Supprimer la s\u00e9lection");
        this.buttonSuppr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TableCellEditor cellEditor = RowValuesTableControlPanel.this.table.getCellEditor();
                if (cellEditor != null) {
                    cellEditor.cancelCellEditing();
                }
                RowValuesTableControlPanel.this.model.removeRowsAt(table.getSelectedRows());
            }
        });
        this.buttonSuppr.setEnabled(false);
        JComponentUtils.setMinimumWidth(this.buttonSuppr, 95);
        ++c.gridx;
        this.add((Component)this.buttonSuppr, c);
        if (l != null) {
            for (JButton button : l) {
                ++c.gridx;
                button.setEnabled(false);
                this.add((Component)button, c);
            }
        }
        this.buttonClone.addMouseListener(this);
        this.buttonSuppr.addMouseListener(this);
        this.buttonInserer.addMouseListener(this);
        this.buttonHaut.addMouseListener(this);
        this.buttonBas.addMouseListener(this);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                System.err.println("RowValuesTableControlPanel.RowValuesTableControlPanel(...).new ListSelectionListener() {...}.valueChanged()" + table.getSelectedRow());
                boolean b = table.getSelectedRow() >= 0;
                RowValuesTableControlPanel.this.buttonClone.setEnabled(b);
                RowValuesTableControlPanel.this.buttonSuppr.setEnabled(b);
                RowValuesTableControlPanel.this.buttonInserer.setEnabled(b);
                RowValuesTableControlPanel.this.buttonHaut.setEnabled(b);
                RowValuesTableControlPanel.this.buttonBas.setEnabled(b);
                if (l != null) {
                    for (JButton button : l) {
                        button.setEnabled(b);
                    }
                }
            }
        });
        ++c.gridx;
        c.weightx = 1.0;
        JPanel panelStuff = new JPanel();
        panelStuff.setOpaque(false);
        this.add((Component)panelStuff, c);
    }

    public void deplacerDe(int inc) {
        int rowIndex = this.table.getSelectedRow();
        int dest = this.model.moveBy(rowIndex, inc);
        this.table.getSelectionModel().setSelectionInterval(dest, dest);
    }

    private void cloneLine(int row) {
        if (row < 0) {
            System.err.println("RowValuesTableControlPanel.cloneLine() wrong selected line, index = " + row);
            Thread.dumpStack();
            return;
        }
        SQLRowValues rowVals = this.model.getRowValuesAt(row);
        SQLRowValues rowValsBis = new SQLRowValues(rowVals);
        rowValsBis.clearPrimaryKeys();
        rowValsBis.put(rowValsBis.getTable().getOrderField().getName(), null);
        this.model.getSQLElement().clearPrivateFields(rowValsBis);
        for (String elt : this.table.getClearCloneTableElement()) {
            if (!rowValsBis.getTable().getFieldsName().contains(elt)) continue;
            rowValsBis.putEmptyLink(elt);
        }
        this.model.addRow(rowValsBis);
    }

    public void setVisibleButtonClone(boolean b) {
        this.buttonClone.setVisible(b);
    }

    public void setVisibleButtonAjouter(boolean b) {
        this.buttonAjouter.setVisible(b);
    }

    public void setVisibleButtonInserer(boolean b) {
        this.buttonInserer.setVisible(b);
    }

    public void setVisibleButtonHaut(boolean b) {
        this.buttonHaut.setVisible(b);
    }

    public void setVisibleButtonBas(boolean b) {
        this.buttonBas.setVisible(b);
    }

    public void setVisibleButtonSuppr(boolean b) {
        this.buttonSuppr.setVisible(b);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JButton source;
        if (e.getSource() instanceof JButton && !(source = (JButton)e.getSource()).isEnabled()) {
            JOptionPane.showMessageDialog(source, MSG);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

