/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.ui.EnhancedTable;
import org.openconcerto.ui.state.JTableStateManager;
import org.openconcerto.ui.table.JCheckBoxTableCellRender;
import org.openconcerto.utils.TableSorter;

public class RowValuesSelector
extends EnhancedTable {
    private final JTableStateManager stateManager;
    private final RowValuesTableModel model;
    private boolean editorAndRendererDone;
    private final SQLTableElement tableElement;
    private final List<ActionListener> listeners = new Vector<ActionListener>();
    private final HashMap<SQLRowValues, Boolean> map = new HashMap();

    public RowValuesSelector(RowValuesTableModel model, File f) {
        this.stateManager = new JTableStateManager(this, f, true);
        this.model = model;
        int i = 0;
        while (i < model.getColumnCount()) {
            model.setEditable(false, i);
            ++i;
        }
        this.tableElement = new SQLTableElement(Boolean.class, ""){
            final JCheckBoxTableCellRender checkBoxTableCellRender;
            {
                this.checkBoxTableCellRender = new JCheckBoxTableCellRender();
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return this.checkBoxTableCellRender;
            }

            @Override
            public TableCellEditor getTableCellEditor(JTable table) {
                return this.checkBoxTableCellRender;
            }

            @Override
            public Object getValueFrom(SQLRowValues row) {
                Boolean o = (Boolean)RowValuesSelector.this.map.get(row);
                if (o == null) {
                    o = Boolean.TRUE;
                    RowValuesSelector.this.map.put(row, o);
                }
                return o;
            }

            @Override
            public void setValueFrom(SQLRowValues row, Object value) {
                RowValuesSelector.this.map.put(row, (Boolean)value);
                super.setValueFrom(row, value);
                RowValuesSelector.this.fireActionEvent();
            }

            @Override
            public boolean isCellEditable(SQLRowValues vals) {
                return true;
            }
        };
        model.addColumn(this.tableElement);
        TableSorter sorter = new TableSorter(model);
        this.setModel(sorter);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                RowValuesSelector.this.updateRenderer();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        });
        this.getTableHeader().setReorderingAllowed(false);
        this.stateManager.loadState();
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                RowValuesSelector.this.repaint();
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        ToolTipManager.sharedInstance().unregisterComponent(this);
        ToolTipManager.sharedInstance().unregisterComponent(this.getTableHeader());
        this.updateRenderer();
    }

    private final synchronized void updateRenderer() {
        if (!this.editorAndRendererDone) {
            this.editorAndRendererDone = true;
            List<SQLTableElement> list = this.model.getList();
            int i = 0;
            while (i < list.size()) {
                TableColumn aColumn = this.getColumnModel().getColumn(i);
                SQLTableElement sqlTableElement = list.get(i);
                TableCellRenderer renderer = sqlTableElement.getTableCellRenderer();
                aColumn.setCellRenderer(renderer);
                ++i;
            }
            TableColumn col = this.getColumnModel().getColumn(this.getColumnModel().getColumnCount() - 1);
            col.setMaxWidth(40);
        }
    }

    public void loadState(String filename) {
        this.stateManager.loadState(new File(filename));
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getPreferredSize().height < this.getParent().getHeight();
    }

    @Override
    protected void resizeAndRepaint() {
        super.resizeAndRepaint();
    }

    public synchronized List<SQLRowValues> getSelectedRowValues() {
        Vector<SQLRowValues> l = new Vector<SQLRowValues>(this.model.getRowCount());
        int i = 0;
        while (i < this.model.getRowCount()) {
            SQLRowValues rowValues = this.model.getRowValuesAt(i);
            if (this.tableElement.getValueFrom(rowValues).equals(Boolean.TRUE)) {
                l.add(rowValues);
            }
            ++i;
        }
        return l;
    }

    public synchronized void addActionListener(ActionListener l) {
        if (this.listeners.contains(l)) {
            throw new IllegalArgumentException("The listener is already an ActionListner of " + this);
        }
        this.listeners.add(l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (!this.listeners.contains(l)) {
            throw new IllegalArgumentException("The listener not an ActionListner of " + this);
        }
        this.listeners.remove(l);
    }

    private synchronized void fireActionEvent() {
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(new ActionEvent(this, this.listeners.size(), "SELECTED_CHANGED"));
        }
    }

    @Override
    public String toString() {
        return "RowValuesSelector with " + this.listeners.size() + " ActionListeners on model: " + this.model;
    }

    @Override
    public void selectAll() {
        this.setAll(true);
    }

    public void unselectAll() {
        this.setAll(false);
    }

    public void select(SQLRowValues row, boolean b) {
        this.map.put(row, b);
        this.model.fireTableDataChanged();
        this.fireActionEvent();
    }

    public void unselect(SQLRowValues row, boolean b) {
        this.map.put(row, b);
        this.model.fireTableDataChanged();
        this.fireActionEvent();
    }

    private void setAll(boolean b) {
        int i = 0;
        while (i < this.model.getRowCount()) {
            SQLRowValues rowValues = this.model.getRowValuesAt(i);
            this.map.put(rowValues, b);
            ++i;
        }
        this.model.fireTableDataChanged();
        this.fireActionEvent();
    }
}

