/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableCellRenderer;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableListener;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;

public class KeyTableCellRenderer
extends DefaultTableCellRenderer {
    private String lastStringValue;
    private Object toSelect;
    private boolean isLoading = false;
    private final SQLElement el;
    static final Map<SQLElement, Map<Integer, IComboSelectionItem>> cacheMap = new HashMap<SQLElement, Map<Integer, IComboSelectionItem>>();

    public KeyTableCellRenderer(SQLElement el) {
        this.el = el;
        if (cacheMap.get(this.el) == null) {
            this.loadCacheAsynchronous();
        }
    }

    @Override
    public void setValue(Object value) {
        if (this.isLoading) {
            this.toSelect = value;
            this.setText("Chargement ...");
            return;
        }
        String newValue = "id non trouv\u00e9 pour:" + value;
        if (value == null) {
            return;
        }
        try {
            if (value instanceof SQLRowValues) {
                newValue = ((SQLRowValues)value).getString("CODE");
            } else {
                int id = Integer.parseInt(value.toString());
                if (id > 1) {
                    IComboSelectionItem item = cacheMap.get(this.el).get(id);
                    if (item != null) {
                        newValue = item.getLabel();
                    }
                } else {
                    newValue = "-- Ind\u00e9fini --";
                }
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        if (!newValue.equals(this.lastStringValue)) {
            this.lastStringValue = newValue;
            this.setText(newValue);
        }
    }

    private void loadCacheAsynchronous() {
        this.isLoading = true;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                List<IComboSelectionItem> items = KeyTableCellRenderer.this.el.getComboRequest().getComboItems();
                final HashMap<Integer, IComboSelectionItem> m = new HashMap<Integer, IComboSelectionItem>();
                for (IComboSelectionItem comboSelectionItem : items) {
                    m.put(comboSelectionItem.getId(), comboSelectionItem);
                }
                cacheMap.put(KeyTableCellRenderer.this.el, m);
                KeyTableCellRenderer.this.el.getTable().addPremierTableListener(new SQLTableListener(){

                    @Override
                    public void rowAdded(SQLTable table, int id) {
                        m.put(id, KeyTableCellRenderer.this.el.getComboRequest().getComboItem(id));
                    }

                    @Override
                    public void rowDeleted(SQLTable table, int id) {
                        m.remove(id);
                    }

                    @Override
                    public void rowModified(SQLTable table, int id) {
                        m.put(id, KeyTableCellRenderer.this.el.getComboRequest().getComboItem(id));
                    }
                });
                KeyTableCellRenderer.this.isLoading = false;
                if (KeyTableCellRenderer.this.toSelect != null) {
                    KeyTableCellRenderer.this.setValue(KeyTableCellRenderer.this.toSelect);
                }
            }
        });
        thread.start();
    }
}

