/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeModifyPanel;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.IFactory;

public class SQLMenuItemHelper {
    public static final SQLMenuItemHelper INSTANCE = new SQLMenuItemHelper();

    protected void postProcessFrame(JFrame f) {
    }

    protected void menuItemCreated(SQLElement elem) {
    }

    protected void actionCreated(AbstractSQLMenuItemAction action) {
    }

    private final <F extends JFrame> F ppFrame(F f, IClosure<F> c) {
        if (c != null) {
            c.executeChecked(f);
        }
        this.postProcessFrame(f);
        return f;
    }

    protected EditFrame createEditFrame(SQLElement elem) {
        return new EditFrame(elem);
    }

    protected IListFrame createListFrame(SQLElement elem) {
        return new IListFrame(new ListeModifyPanel(elem));
    }

    public final JMenuItem createEditMenuItem(SQLElement elem) {
        this.menuItemCreated(elem);
        return new JMenuItem(this.createEditAction(elem));
    }

    public final SQLMenuItemAction createEditAction(final SQLElement elem) {
        SQLMenuItemAction menuItemAction = new SQLMenuItemAction(elem, "Cr\u00e9er " + elem.getSingularName(), (IFactory<? extends JFrame>)new IFactory<JFrame>(){

            @Override
            public JFrame createChecked() {
                return SQLMenuItemHelper.this.ppFrame(SQLMenuItemHelper.this.createEditFrame(elem), null);
            }
        });
        this.actionCreated(menuItemAction);
        return menuItemAction;
    }

    public final JMenuItem createListMenuItem(SQLElement elem) {
        return this.createListMenuItem(elem, null);
    }

    public final JMenuItem createListMenuItem(SQLElement elem, IClosure<IListFrame> initFrame) {
        this.menuItemCreated(elem);
        return new JMenuItem(this.createListAction(elem, initFrame));
    }

    public final SQLMenuItemAction createListAction(SQLElement elem) {
        return this.createListAction(elem, null);
    }

    public final SQLMenuItemAction createListAction(final SQLElement elem, final IClosure<IListFrame> initFrame) {
        SQLMenuItemAction menuItemAction = new SQLMenuItemAction(elem, "G\u00e9rer les " + elem.getPluralName(), (IFactory<? extends JFrame>)new IFactory<JFrame>(){

            @Override
            public JFrame createChecked() {
                return SQLMenuItemHelper.this.ppFrame(SQLMenuItemHelper.this.createListFrame(elem), initFrame);
            }
        });
        this.actionCreated(menuItemAction);
        return menuItemAction;
    }

    public final void addMenuItems(JMenu menu, SQLElement elem) {
        this.addMenuItems(menu, elem, true, true);
    }

    public final void addMenuItems(JMenu menu, SQLElement elem, boolean edit, boolean list) {
        this.addMenuItems(menu, elem, edit, list, null);
    }

    public final void addMenuItems(JMenu menu, SQLElement elem, boolean edit, boolean list, IClosure<IListFrame> listInit) {
        if (elem != null) {
            if (edit) {
                menu.add(this.createEditMenuItem(elem));
            }
            if (list) {
                menu.add(this.createListMenuItem(elem, listInit));
            }
        }
    }

    public static abstract class AbstractSQLMenuItemAction
    extends AbstractAction {
        private final SQLElement elem;
        private JFrame frame;
        private boolean cacheFrame;

        public AbstractSQLMenuItemAction(SQLElement elem, String name) {
            super(name);
            this.elem = elem;
            this.frame = null;
            this.cacheFrame = true;
        }

        public final void setCacheFrame(boolean cacheFrame) {
            if (this.cacheFrame != cacheFrame) {
                this.cacheFrame = cacheFrame;
                this.frame = null;
            }
        }

        public final JFrame getFrame() {
            if (this.cacheFrame) {
                if (this.frame == null) {
                    this.frame = this.createFrame();
                }
                return this.frame;
            }
            return this.createFrame();
        }

        protected abstract JFrame createFrame();

        public final SQLElement getElem() {
            return this.elem;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.getFrame().setVisible(true);
        }
    }

    public static class SQLMenuItemAction
    extends AbstractSQLMenuItemAction {
        private final IFactory<? extends JFrame> frameFactory;

        public SQLMenuItemAction(SQLElement elem, String name, IFactory<? extends JFrame> frameFactory) {
            super(elem, name);
            this.frameFactory = frameFactory;
        }

        @Override
        protected JFrame createFrame() {
            return this.frameFactory.createChecked();
        }
    }
}

