/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;

public class ListeModifyPanel
extends IListPanel
implements ValidListener {
    private SQLComponent modifComp;
    private JScrollPane scrollPane;
    private String validText = null;

    public ListeModifyPanel(SQLElement elem) {
        super(elem);
    }

    public ListeModifyPanel(SQLElement elem, IListe list) {
        super(elem, list);
    }

    @Override
    public SQLComponent getModifComp() {
        return this.modifComp;
    }

    @Override
    protected SQLComponent getSQLComponent() {
        return this.getModifComp();
    }

    @Override
    protected void addComponents(Container container, GridBagConstraints c) {
        this.modifComp = this.element.createComponent();
        this.modifComp.setMode(SQLComponent.Mode.MODIFICATION);
        this.getModifComp().uiInit();
        this.getModifComp().select(null);
        this.getModifComp().addValidListener(this);
        this.btnMngr.setAdditional(this.buttonModifier, new ITransformer<JButton, String>(){

            @Override
            public String transformChecked(JButton input) {
                return EditPanel.computeTooltip(ListeModifyPanel.this.validText == null, ListeModifyPanel.this.validText);
            }
        });
        this.scrollPane = new JScrollPane(this.getModifComp());
        Dimension d = this.getModifComp().getPreferredSize();
        if (d.height > 300) {
            d.height = 300;
        }
        this.scrollPane.setMinimumSize(d);
        ++c.gridy;
        c.weighty = 0.0;
        container.add((Component)this.scrollPane, c);
    }

    @Override
    protected void handleAction(JButton source, ActionEvent evt) {
        if (source == this.buttonModifier) {
            this.getModifComp().update();
        } else {
            super.handleAction(source, evt);
        }
    }

    @Override
    protected void listSelectionChanged(int id) {
        super.listSelectionChanged(id);
        final int scroll = this.scrollPane.getVerticalScrollBar().getValue();
        this.getModifComp().select(id);
        this.validChange(this.getModifComp(), this.getModifComp().isValidated());
        this.getModifComp().setEditable(id != -1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ListeModifyPanel.this.scrollPane.getVerticalScrollBar().setValue(scroll);
            }
        });
    }

    @Override
    public void validChange(ValidObject src, boolean newValue) {
        this.validText = newValue ? null : this.getModifComp().getValidationText();
        this.btnMngr.updateBtn(this.buttonModifier);
    }
}

