/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.HierarchyLevel;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.utils.FileUtils;

public abstract class SQL_URL {
    private static final String jdbcPrefix = "jdbc:";
    private final String originalURL;
    private final SQLSystem system;
    private final String login;
    private final String pass;
    private final String sysRoot;
    private final String root;
    private final String tableName;

    public static SQL_URL create(String url) throws URISyntaxException {
        if (url.startsWith(jdbcPrefix)) {
            return JDBCUrl.createP(url);
        }
        return SQL_URI.createP(url);
    }

    protected SQL_URL(String originalURL, SQLSystem system, String login, String pass, String sysRoot, String root, String tableName) {
        if (sysRoot == null) {
            throw new IllegalArgumentException("null sysRoot");
        }
        if (root == null) {
            throw new IllegalArgumentException("null root");
        }
        this.originalURL = originalURL;
        this.system = system;
        this.login = login;
        this.pass = pass;
        this.sysRoot = sysRoot;
        this.root = root;
        this.tableName = tableName;
    }

    public final SQLSystem getSystem() {
        return this.system;
    }

    public final String getLogin() {
        return this.login;
    }

    public final String getPass() {
        return this.pass;
    }

    public abstract String getServerName();

    public final String getSystemRootName() {
        return this.sysRoot;
    }

    public final String getRootName() {
        return this.root;
    }

    public final String getTableName() {
        return this.tableName;
    }

    public final String asString() {
        return this.originalURL;
    }

    public final String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.asString();
    }

    static final class JDBCUrl
    extends SQL_URL {
        private final String name;

        static JDBCUrl createP(String url) {
            SQLSystem system = SQLSystem.get(url.substring(SQL_URL.jdbcPrefix.length(), url.indexOf(58, SQL_URL.jdbcPrefix.length())));
            return new JDBCUrl(url, system, system.getConnectionInfo(url));
        }

        private JDBCUrl(String originalURL, SQLSystem sys, Map<String, String> connectionInfo) {
            super(originalURL, sys, connectionInfo.get("login"), connectionInfo.get("pass"), connectionInfo.get("systemRoot"), connectionInfo.get("root"), connectionInfo.get("table"));
            this.name = connectionInfo.get("name");
        }

        @Override
        public final String getServerName() {
            return this.name;
        }
    }

    static final class SQL_URI
    extends SQL_URL {
        private final URI uri;

        static SQL_URL createP(String url) throws URISyntaxException {
            String pass;
            String login;
            URI uri = new URI(url);
            SQLSystem system = SQLSystem.get(uri.getScheme());
            String[] ui = uri.getUserInfo().split(":");
            if (ui.length == 1) {
                login = ui[0];
                pass = null;
            } else if (ui.length == 2) {
                login = ui[0];
                pass = ui[1];
            } else {
                throw new IllegalArgumentException("invalid user:pass " + uri.getUserInfo());
            }
            List<File> path = FileUtils.getAncestors(new File(uri.getPath()));
            path.remove(0);
            String sysRoot = system.getDBLevel(DBSystemRoot.class) == HierarchyLevel.SQLSERVER ? uri.getHost() : path.remove(0).getName();
            if (path.size() <= 0) {
                throw new IllegalArgumentException("Not root specified for the SystemRoot: " + sysRoot);
            }
            String root = path.remove(0).getName();
            String tableName = path.size() > 0 ? path.remove(0).getName() : null;
            return new SQL_URI(url, uri, system, login, pass, sysRoot, root, tableName);
        }

        private SQL_URI(String originalURL, URI uri, SQLSystem sys, String login, String pass, String systemRoot, String root, String tableName) {
            super(originalURL, sys, login, pass, systemRoot, root, tableName);
            this.uri = uri;
        }

        public final String getHost() {
            return this.uri.getHost();
        }

        public final int getPort() {
            return this.uri.getPort();
        }

        @Override
        public final String getServerName() {
            return this.getSystem().getServerName(String.valueOf(this.getHost()) + (this.getPort() < 0 ? "" : ":" + this.getPort()));
        }
    }
}

