/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.model.ConnectionHandler;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLSystem;

public class SQLUtils {
    public static final String SPLIT_DELIMITER = "$jdbcDelimiter$";
    private static final Pattern splitMySQLQueries = Pattern.compile(";\r?\n");
    public static final Pattern SPLIT_PATTERN = Pattern.compile("$jdbcDelimiter$", 16);

    public static <T> T executeAtomic(SQLDataSource ds, final SQLFactory<T> f) throws SQLException {
        return SQLUtils.executeAtomic(ds, new ConnectionHandlerNoSetup<T, SQLException>(){

            @Override
            public T handle(SQLDataSource ds) throws SQLException {
                return f.create();
            }
        });
    }

    public static <T, X extends Exception> T executeAtomic(SQLDataSource ds, final ConnectionHandlerNoSetup<T, X> h) throws SQLException, X {
        return ds.useConnection(new ConnectionHandler<T, X>(){
            private Boolean autoCommit = null;

            @Override
            public boolean canRestoreState() {
                return true;
            }

            @Override
            public void setup(Connection conn) throws SQLException {
                this.autoCommit = conn.getAutoCommit();
                if (this.autoCommit.booleanValue()) {
                    conn.setAutoCommit(false);
                }
            }

            @Override
            public T handle(SQLDataSource ds) throws Exception, SQLException {
                return h.handle(ds);
            }

            @Override
            public void restoreState(Connection conn) throws SQLException {
                if (this.autoCommit == Boolean.TRUE) {
                    try {
                        try {
                            this.get();
                            conn.commit();
                        }
                        catch (Exception e) {
                            conn.rollback();
                            conn.setAutoCommit(true);
                        }
                    }
                    finally {
                        conn.setAutoCommit(true);
                    }
                }
            }
        });
    }

    public static <T> T executeAtomic(Connection conn, SQLFactory<T> f) throws SQLException {
        T res;
        block7: {
            boolean autoCommit = conn.getAutoCommit();
            if (autoCommit) {
                conn.setAutoCommit(false);
                try {
                    try {
                        res = f.create();
                        conn.commit();
                        break block7;
                    }
                    catch (SQLException e) {
                        conn.rollback();
                        throw e;
                    }
                    catch (RuntimeException e) {
                        conn.rollback();
                        throw e;
                    }
                }
                finally {
                    conn.setAutoCommit(true);
                }
            }
            res = f.create();
        }
        return res;
    }

    public static List<String> createPostgreSQLSeq(String seqName, String sqlType, String minVal, String inc) {
        ArrayList<String> res = new ArrayList<String>();
        String genT = String.valueOf(seqName) + "_generator";
        res.add("DROP TABLE if exists " + genT);
        res.add("CREATE TABLE " + genT + " ( " + SQLUtils.decl(new String[]{"minVal", "inc", "currentVal", "tmpVal"}, sqlType) + ")");
        String body = "UPDATE " + genT + " set tmpVal = currentVal, currentVal = currentVal + inc ;";
        body = String.valueOf(body) + "SELECT tmpVal from " + genT + ";";
        res.addAll(SQLUtils.createFunction("next_" + seqName, sqlType, body));
        body = "update " + genT + " set currentVal = minVal ;";
        body = String.valueOf(body) + "select currentVal from " + genT + ";";
        res.addAll(SQLUtils.createFunction("reset_" + seqName, sqlType, body));
        res.add("INSERT INTO " + genT + " values(" + minVal + ", (" + inc + ") )");
        res.add("SELECT reset_" + seqName + "()");
        return res;
    }

    private static String decl(String[] cols, String type) {
        String res = "";
        String[] stringArray = cols;
        int n = cols.length;
        int n2 = 0;
        while (n2 < n) {
            String col = stringArray[n2];
            res = String.valueOf(res) + col + " " + type + ",";
            ++n2;
        }
        return res.substring(0, res.length() - 1);
    }

    private static List<String> createFunction(String name, String type, String body) {
        ArrayList<String> res = new ArrayList<String>();
        res.add("DROP FUNCTION if exists " + name + "()");
        String f = "CREATE FUNCTION " + name + "() RETURNS " + type + " AS $createFunction$ ";
        f = String.valueOf(f) + body;
        f = String.valueOf(f) + " $createFunction$ LANGUAGE SQL";
        res.add(f);
        return res;
    }

    public static void executeScript(String sql, DBSystemRoot sysRoot) throws SQLException {
        SQLSystem sys = sysRoot.getServer().getSQLSystem();
        Pattern p = sys == SQLSystem.MYSQL || sys == SQLSystem.MSSQL ? splitMySQLQueries : SPLIT_PATTERN;
        SQLUtils.executeScript(sql, sysRoot, p);
    }

    public static void executeScript(String sql, DBSystemRoot sysRoot, Pattern p) throws SQLException {
        try {
            String[] stringArray = p.split(sql);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                String trimmed = s.trim();
                if (trimmed.length() > 0) {
                    sysRoot.getDataSource().execute(trimmed, (ResultSetHandler)null);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new SQLException("unable to execute " + sql, e);
        }
    }

    public static interface SQLFactory<T> {
        public T create() throws SQLException;
    }
}

