/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.cc.ITransformer;

public final class RowURIFormat {
    private final DBSystemRoot sysRoot;
    private final ITransformer<SQLTable, SQLElement> dir;

    public RowURIFormat() {
        this(Configuration.getInstance());
    }

    public RowURIFormat(Configuration conf) {
        this(conf.getSystemRoot(), conf.getDirectory());
    }

    public RowURIFormat(DBSystemRoot systemRoot, final SQLElementDirectory dir) {
        this(systemRoot, new ITransformer<SQLTable, SQLElement>(){

            @Override
            public SQLElement transformChecked(SQLTable input) {
                return dir.getElement(input);
            }
        });
    }

    public RowURIFormat(DBSystemRoot sysRoot, ITransformer<SQLTable, SQLElement> dir) {
        if (sysRoot == null) {
            throw new NullPointerException("null system root");
        }
        this.sysRoot = sysRoot;
        this.dir = dir;
    }

    private final SQLElement getElement(SQLTable t) {
        return this.dir.transformChecked(t);
    }

    public final SQLRow parse(URI uri) {
        String uriSysRoot;
        if (!"row".equals(uri.getScheme())) {
            throw new IllegalArgumentException("not a row URI : " + uri);
        }
        File rowF = new File(uri.getPath());
        File tableF = rowF.getParentFile();
        File rootF = tableF.getParentFile();
        File sysRootF = rootF.getParentFile();
        String string = uriSysRoot = sysRootF.getName().length() == 0 ? uri.getHost() : sysRootF.getName();
        if (!CompareUtils.equals(this.sysRoot.getName(), uriSysRoot)) {
            throw new IllegalArgumentException("not in this system root : " + uri);
        }
        SQLTable table = this.sysRoot.getRoot(rootF.getName()).getTable(tableF.getName());
        return new SQLRow(table, Integer.valueOf(rowF.getName()));
    }

    private final String getLinkStart(SQLTable t, boolean htmlTag) {
        DBSystemRoot sysRoot = t.getDBSystemRoot();
        if (sysRoot != this.sysRoot) {
            throw new IllegalArgumentException(t + " is not in " + this.sysRoot);
        }
        return String.valueOf(htmlTag ? "<a href=\"" : "") + "row://" + sysRoot.getName() + "/" + t.getDBRoot().getName() + "/" + t.getName() + "/";
    }

    private final String getLinkEnd(SQLRow r, boolean htmlTag) {
        return String.valueOf(r.getID()) + (htmlTag ? "\">" + this.getLinkContent(r) + "</a> " : "");
    }

    public final String getLinkContent(SQLRow r) {
        return this.getElement(r.getTable()).getDescription(r);
    }

    public final String format(SQLRow r, boolean htmlTag) {
        return String.valueOf(this.getLinkStart(r.getTable(), htmlTag)) + this.getLinkEnd(r, htmlTag);
    }

    public final List<String> format(List<SQLRow> rows, boolean htmlTag) {
        ArrayList<String> res = new ArrayList<String>(rows.size());
        for (SQLRow r : rows) {
            res.add(this.format(r, htmlTag));
        }
        return res;
    }

    public final List<String> format(SQLTable t, Collection<? extends Number> ids, boolean htmlTag) {
        ArrayList<String> res = new ArrayList<String>(ids.size());
        String linkStart = this.getLinkStart(t, htmlTag);
        for (Number number : ids) {
            int id = number.intValue();
            res.add(String.valueOf(linkStart) + this.getLinkEnd(new SQLRow(t, id), htmlTag));
        }
        return res;
    }

    public static abstract class HTMLTextField
    extends org.openconcerto.ui.component.HTMLTextField {
        private final RowURIFormat parser;

        public HTMLTextField(String html, RowURIFormat parser) {
            super(html);
            this.parser = parser;
        }

        protected final SQLElement getElement(SQLTable table) {
            return this.parser.getElement(table);
        }

        @Override
        protected final void linkActivated(HyperlinkEvent e, JComponent src) {
            try {
                this.linkActivated(this.parser.parse(new URI(e.getDescription())), src);
            }
            catch (Exception exn) {
                ExceptionHandler.handle(src, "Impossible d'ouvrir " + e.getDescription(), exn);
            }
        }

        protected abstract void linkActivated(SQLRow var1, JComponent var2);
    }
}

