/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.List;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.StringUtils;

public class ClassGenerator {
    public static void generate(SQLTable t, String classname) {
        try {
            FileOutputStream fop = new FileOutputStream("out.java");
            PrintStream out = new PrintStream(fop);
            List<SQLField> f = t.getOrderedFields();
            f.remove(t.getArchiveField());
            f.remove(t.getOrderField());
            f.remove(t.getKey());
            ClassGenerator.generateAutoLayoutedJComponent(t, f, classname, out, null);
            out.println("");
            ClassGenerator.generateMappingXML(t, f, out);
            out.close();
            fop.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void generateMappingXML(SQLTable t, List f, PrintStream out) {
        out.println("<TABLE name=\"" + t.getName() + "\">");
        for (SQLField element : f) {
            String fieldName = StringUtils.firstUpThenLow(element.getName()).replace('_', ' ');
            out.println("   <FIELD name=\"" + element.getName() + "\" label=\"" + fieldName + "\" titleLabel=\"" + fieldName + "\" />");
        }
        out.println("</TABLE>");
    }

    public static List generateAutoLayoutedJComponent(SQLTable t, List f, String classname, PrintStream out, String packageName) {
        if (packageName != null && packageName.length() > 0) {
            out.print("package ");
            out.print(packageName);
            out.println(";");
            out.println();
        }
        out.println("import org.openconcerto.sql.element.ConfSQLElement;");
        out.println("import org.openconcerto.sql.element.SQLComponent;");
        out.println("import org.openconcerto.sql.element.UISQLComponent;");
        out.println("import org.openconcerto.sql.model.SQLRow;");
        out.println();
        out.println("import java.util.ArrayList;");
        out.println("import java.util.HashSet;");
        out.println("import java.util.List;");
        out.println("import java.util.Set;");
        out.println();
        out.println("public class " + classname + " extends ConfSQLElement {");
        out.println();
        out.println("    public " + classname + "() {");
        out.println("        super(\"" + t.getName() + "\", \"un " + t.getName().toLowerCase() + " \", \"" + t.getName().toLowerCase() + "s\");");
        out.println("    }");
        out.println();
        out.println("    protected List<String> getListFields() {");
        out.println("        final List<String> l = new ArrayList<String>();");
        for (SQLField element : f) {
            if (element.isPrimaryKey() || element.getName().equals("ORDRE")) continue;
            out.println("        l.add(\"" + element.getName() + "\");");
        }
        out.println("        return l;");
        out.println("    }");
        out.println();
        out.println("    protected List<String> getComboFields() {");
        out.println("        final List<String> l = new ArrayList<String>();");
        for (SQLField element : f) {
            if (element.isPrimaryKey() || element.getName().equals("ORDRE")) continue;
            out.println("        l.add(\"" + element.getName() + "\");");
        }
        out.println("        return l;");
        out.println("    }");
        out.println();
        out.println("    public SQLComponent createComponent() {");
        out.println("        return new UISQLComponent(this) {");
        out.println();
        out.println("            @Override");
        out.println("            protected Set<String> createRequiredNames() {");
        out.println("                final Set<String> s = new HashSet<String>();");
        for (SQLField element : f) {
            if (element.isPrimaryKey() || element.getName().equals("ORDRE")) continue;
            out.println("                // s.add(\"" + element.getName() + "\");");
        }
        out.println("                return s;");
        out.println("            }");
        out.println();
        out.println("            public void addViews() {");
        SQLField first = null;
        for (SQLField element : f) {
            if (first == null) {
                first = element;
            }
            if (element.isPrimaryKey() || element.getName().equals("ORDRE")) continue;
            out.println("                this.addView(\"" + element.getName() + "\");");
        }
        out.println("            }");
        out.println("        };");
        out.println("    }");
        out.println();
        out.println("    public String getDescription(SQLRow fromRow) {");
        out.println("        return fromRow.getString(\"" + first.getName() + "\");");
        out.println("    }");
        out.println();
        out.println("}");
        return f;
    }

    public static String generateAutoLayoutedJComponent(SQLTable table, String c, String packageName) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(b);
        List<SQLField> f = ClassGenerator.getOrderedContentFields(table);
        ClassGenerator.generateAutoLayoutedJComponent(table, f, c, ps, packageName);
        ps.close();
        return b.toString();
    }

    public static String generateMappingXML(SQLTable table, String c) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(b);
        List<SQLField> f = ClassGenerator.getOrderedContentFields(table);
        ClassGenerator.generateMappingXML(table, f, ps);
        ps.close();
        return b.toString();
    }

    private static List<SQLField> getOrderedContentFields(SQLTable table) {
        List<SQLField> f = table.getOrderedFields();
        f.retainAll(table.getContentFields());
        return f;
    }

    public static String getStandardClassName(String n) {
        int nb = n.length();
        StringBuilder b = new StringBuilder(nb);
        if (n.toUpperCase().equals(n)) {
            n = n.toLowerCase();
        }
        n = StringUtils.firstUp(n);
        int i = 0;
        while (i < nb) {
            char c = n.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                b.append(c);
            }
            ++i;
        }
        return b.toString();
    }
}

