/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.util.Set;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.rights.TableAllRights;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.utils.cc.IFactory;

public class UserRights {
    private final int userID;

    public UserRights(int userID) {
        this.userID = userID;
    }

    public final boolean haveRight(String code) {
        return this.haveRight(code, null);
    }

    public boolean haveRight(String code, String object) {
        return UserRightsManager.getInstance().haveRight(this.userID, code, object);
    }

    public final Set<String> getObjects(String code, IFactory<Set<String>> allObjects) {
        if (this.haveRight(code)) {
            return null;
        }
        return UserRightsManager.getInstance().getObjects(this.userID, code, allObjects);
    }

    public final boolean canDelete(SQLTable table) {
        return TableAllRights.hasRight(this, "DELETE_ROW", table);
    }

    public final boolean canModify(SQLTable table) {
        return TableAllRights.hasRight(this, "UPDATE_ROW", table);
    }

    public boolean canModifyRights() {
        return this.canModify(UserRightsManager.getInstance().getTable());
    }

    public final boolean canAdd(SQLTable table) {
        return TableAllRights.hasRight(this, "INSERT_ROW", table);
    }

    public final boolean canView(SQLTable table) {
        return TableAllRights.hasRight(this, "SELECT_ROW", table);
    }

    public final boolean isSuperUser() {
        return this.haveRight(null);
    }
}

