/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.rights.MacroRight;
import org.openconcerto.sql.users.rights.UserRights;
import org.openconcerto.sql.users.rights.UserRightsManager;

public class TableAllRights
extends MacroRight {
    public static final String CODE = "TABLE_ALL_RIGHTS";
    public static final String CODE_MODIF = "TABLE_ALL_MODIF_RIGHTS";
    public static final String DELETE_ROW_TABLE = "DELETE_ROW";
    public static final String MODIFY_ROW_TABLE = "UPDATE_ROW";
    public static final String ADD_ROW_TABLE = "INSERT_ROW";
    public static final String VIEW_ROW_TABLE = "SELECT_ROW";

    public static UserRightsManager.RightTuple createRight(SQLTable t, boolean b) {
        return TableAllRights.createRight(CODE, t, b);
    }

    public static UserRightsManager.RightTuple createRight(String code, SQLTable t, boolean b) {
        return new UserRightsManager.RightTuple(code, TableAllRights.tableToString(t), b);
    }

    public static boolean hasRight(UserRights u, String code, SQLTable t) {
        return u.haveRight(code, TableAllRights.tableToString(t));
    }

    static String tableToString(SQLTable t) {
        return t == null ? null : t.getSQLName(t.getDBRoot()).quote();
    }

    public TableAllRights() {
        this(true);
    }

    public TableAllRights(boolean includeView) {
        super(includeView ? CODE : CODE_MODIF);
    }

    public void load(UserRights userRights, Boolean b) {
        throw new IllegalStateException();
    }

    @Override
    public List<UserRightsManager.RightTuple> expand(UserRightsManager mngr, String rightCode, String object, boolean haveRight) {
        ArrayList<UserRightsManager.RightTuple> res = new ArrayList<UserRightsManager.RightTuple>();
        res.add(new UserRightsManager.RightTuple(DELETE_ROW_TABLE, object, haveRight));
        res.add(new UserRightsManager.RightTuple(MODIFY_ROW_TABLE, object, haveRight));
        res.add(new UserRightsManager.RightTuple(ADD_ROW_TABLE, object, haveRight));
        if (this.getCode() == CODE) {
            res.add(new UserRightsManager.RightTuple(VIEW_ROW_TABLE, object, haveRight));
        }
        return res;
    }
}

