/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.sqlobject.itemview.RowItemViewComponent;
import org.openconcerto.ui.component.JRadioButtons;

public class RadioButtons
extends JRadioButtons<Integer>
implements RowItemViewComponent {
    private final String colName;
    private SQLField field;

    public RadioButtons() {
        this("LABEL");
    }

    public RadioButtons(String colName) {
        this.colName = colName;
    }

    private final Map<Integer, String> createChoices() {
        TreeMap<Integer, String> res = new TreeMap<Integer, String>();
        SQLTable choiceTable = this.getTable().getBase().getGraph().getForeignTable(this.field);
        if (choiceTable == null) {
            throw new IllegalArgumentException("The field:" + this.field + " is not a foreign key");
        }
        SQLSelect sel = new SQLSelect(this.getTable().getBase());
        sel.addSelectStar(choiceTable);
        List choicesR = (List)this.getTable().getBase().getDataSource().execute(sel.asString(), new SQLRowListRSH(choiceTable, true));
        for (SQLRow choice : choicesR) {
            String choiceLabel = choice.getString(this.colName);
            res.put(choice.getID(), choiceLabel);
        }
        return res;
    }

    @Override
    public final void init(SQLRowItemView v) {
        this.field = v.getField();
        this.init(this.getForeignTable().getUndefinedID(), this.createChoices());
    }

    private final SQLTable getForeignTable() {
        if (this.getField() == null) {
            throw new IllegalStateException(this + " not initialized.");
        }
        return this.getTable().getBase().getGraph().getForeignTable(this.getField());
    }

    private final SQLTable getTable() {
        return this.field.getTable();
    }

    private final SQLField getField() {
        return this.field;
    }
}

