/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.MutableComboBoxModel;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.PolymorphFK;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.itemview.RowItemViewComponent;
import org.openconcerto.utils.checks.MutableValueObject;
import org.openconcerto.utils.model.ListComboBoxModel;

public class IPolyCombo
extends JPanel
implements MutableValueObject<SQLRow>,
RowItemViewComponent {
    private PolymorphFK field;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);
    private final JComboBox tableCombo;
    private final Map<SQLElement, ElementComboBox> idCombos = new HashMap<SQLElement, ElementComboBox>();
    private final Map<String, SQLElement> name2elem = new HashMap<String, SQLElement>();

    public static final IPolyCombo create(DBRoot root, String tables) {
        List<String> tablesL = SQLRow.toList(tables);
        ArrayList<SQLElement> elements = new ArrayList<SQLElement>(tablesL.size());
        for (String tableName : tablesL) {
            elements.add(Configuration.getInstance().getDirectory().getElement(root.getTableDesc(tableName)));
        }
        return new IPolyCombo(elements);
    }

    public IPolyCombo(List<SQLElement> elements) {
        for (SQLElement element : elements) {
            ElementComboBox c = new ElementComboBox();
            c.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    IPolyCombo.this.fireValueChange();
                }
            });
            this.idCombos.put(element, c);
            this.name2elem.put(element.getTable().getName(), element);
        }
        if (this.name2elem.size() != this.idCombos.size()) {
            throw new IllegalArgumentException("size mismatch: " + this.idCombos.keySet() + " / " + this.name2elem.keySet());
        }
        this.tableCombo = new JComboBox(new ListComboBoxModel((Collection<?>)elements));
        ((MutableComboBoxModel)this.tableCombo.getModel()).insertElementAt(null, 0);
        this.tableCombo.setRenderer(new BasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel c = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                SQLElement element = (SQLElement)value;
                c.setText(element == null ? "----- ??? -----" : element.getSingularName());
                return c;
            }
        });
        this.tableCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                IPolyCombo.this.updateIdCombo();
            }
        });
    }

    protected final void fireValueChange() {
        this.supp.firePropertyChange("value", null, this.getValue());
    }

    protected void updateIdCombo() {
        if (this.getComponentCount() > 1) {
            this.remove(1);
        }
        if (this.getIdCombo() != null) {
            this.add(this.getIdCombo());
        }
        this.revalidate();
        this.fireValueChange();
    }

    private final SQLElement getSelectedElement() {
        return (SQLElement)this.tableCombo.getSelectedItem();
    }

    private final ElementComboBox getIdCombo() {
        return this.idCombos.get(this.getSelectedElement());
    }

    @Override
    public void init(SQLRowItemView v) {
        SQLField f = v.getField();
        this.field = new PolymorphFK(f.getTable(), PolymorphFK.tableField2propName(f));
        this.setLayout(new GridLayout(1, 2));
        this.add(this.tableCombo);
        for (SQLElement element : this.idCombos.keySet()) {
            ElementComboBox c = this.idCombos.get(element);
            c.init(element);
        }
        this.resetValue();
    }

    @Override
    public final void resetValue() {
        this.setValue(null);
    }

    @Override
    public void setValue(SQLRow foreignRow) {
        String tableName = foreignRow == null ? null : foreignRow.getTable().getName();
        this.tableCombo.setSelectedItem(this.name2elem.get(tableName));
        if (this.getIdCombo() != null) {
            this.getIdCombo().setValue(foreignRow.getID());
        }
    }

    @Override
    public SQLRow getValue() {
        if (this.getIdCombo() == null) {
            return null;
        }
        return this.getIdCombo().getSelectedRow();
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }

    public final PolymorphFK getPolymorphFK() {
        return this.field;
    }

    @Override
    public void setEnabled(boolean b) {
        this.tableCombo.setEnabled(b);
        for (JComponent jComponent : this.idCombos.values()) {
            jComponent.setEnabled(b);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.field;
    }
}

