/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.preferences.UserProps;
import org.openconcerto.sql.sqlobject.IComboModel;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.ui.Login;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.ReloadPanel;
import org.openconcerto.ui.valuewrapper.EmptyValueWrapper;
import org.openconcerto.ui.valuewrapper.ValueWrapperFactory;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.JImage;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.EmptyObj;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class ConnexionPanel
extends JPanel
implements ActionListener {
    public static final String QUICK_LOGIN = "org.openconcerto.quickLogin";
    private final Login login;
    private final JButton buttonConnect = new JButton("Connexion");
    private final JPasswordField textPassWord;
    private final EmptyValueWrapper<String> textLogin;
    private SQLRequestComboBox comboSociete;
    private String encryptedPassword;
    protected String clearPassword;
    private final JCheckBox saveCheckBox = new JCheckBox("M\u00e9moriser le mot de passe");
    private final Runnable r;
    private final boolean societeSelector;
    private final ReloadPanel reloadPanel;
    private boolean isConnecting = false;
    private String connectionAllowed;
    private static final String LOGIN_ADMIN = "Administrateur";

    private static boolean quickLogin(Runnable r, boolean societeSelector) {
        Tuple2<String, String> res;
        String lastLogin = UserProps.getInstance().getLastLoginName();
        String pass = UserProps.getInstance().getStoredPassword();
        if (Boolean.getBoolean(QUICK_LOGIN) && lastLogin.length() > 0 && pass != null && (!societeSelector || UserProps.getInstance().getLastSocieteID() >= 0) && (res = new Login(Configuration.getInstance().getRoot()).connectEnc(lastLogin, pass)).get0() == null) {
            r.run();
            return true;
        }
        return false;
    }

    public static ConnexionPanel create(Runnable r, JImage imageLogo) {
        return ConnexionPanel.create(r, imageLogo, false);
    }

    public static ConnexionPanel create(Runnable r, JImage imageLogo, boolean societeSelector) {
        if (ConnexionPanel.quickLogin(r, societeSelector)) {
            return null;
        }
        return new ConnexionPanel(r, imageLogo, societeSelector);
    }

    public ConnexionPanel(Runnable r, JImage imageLogo) {
        this(r, imageLogo, false);
    }

    public ConnexionPanel(Runnable r, JImage imageLogo, boolean societeSelector) {
        this(r, imageLogo, societeSelector, true);
    }

    public ConnexionPanel(Runnable r, JImage imageLogo, boolean societeSelector, boolean allowStoredPass) {
        String storedPassword;
        this.login = new Login(Configuration.getInstance().getRoot());
        this.societeSelector = societeSelector;
        this.r = r;
        String lastLoginName = UserProps.getInstance().getLastLoginName();
        if (lastLoginName == null || lastLoginName.trim().length() == 0) {
            lastLoginName = LOGIN_ADMIN;
        }
        this.encryptedPassword = storedPassword = allowStoredPass ? UserProps.getInstance().getStoredPassword() : null;
        this.connectionAllowed = null;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        imageLogo.check();
        this.add((Component)imageLogo, c);
        ++c.gridy;
        c.gridwidth = 0;
        this.add((Component)new JSeparator(0), c);
        c.insets = new Insets(2, 2, 1, 2);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        JLabel login = new JLabel("Identifiant");
        login.setHorizontalAlignment(4);
        this.add((Component)login, c);
        this.textLogin = new EmptyValueWrapper<String>(ValueWrapperFactory.create(new JTextField(), String.class));
        this.textLogin.setValue(lastLoginName);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textLogin.getComp(), c);
        ((JTextField)this.textLogin.getComp()).addActionListener(this);
        this.textLogin.addEmptyListener(new EmptyListener(){

            @Override
            public void emptyChange(EmptyObj src, boolean newValue) {
                ConnexionPanel.this.checkValidity();
            }
        });
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        JLabel passWord = new JLabel("Mot de passe");
        passWord.setHorizontalAlignment(4);
        this.add((Component)passWord, c);
        this.textPassWord = new JPasswordField();
        if (storedPassword != null) {
            char[] s = new char[8];
            Arrays.fill(s, ' ');
            this.textPassWord.setText(new String(s));
            this.clearPassword = null;
        } else {
            this.clearPassword = "";
        }
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textPassWord, c);
        this.textPassWord.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                ConnexionPanel.this.clearPassword = String.valueOf(ConnexionPanel.this.textPassWord.getPassword());
                ConnexionPanel.this.checkValidity();
            }
        });
        this.textPassWord.addActionListener(this);
        if (societeSelector) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            JLabel societe = new JLabel("Soci\u00e9t\u00e9");
            societe.setHorizontalAlignment(4);
            this.add((Component)societe, c);
            SQLTable tableSociete = this.login.getUserTable().getDBRoot().findTable("SOCIETE_COMMON");
            if (tableSociete == null) {
                throw ExceptionUtils.createExn(IllegalStateException.class, "Table manquante: SOCIETE_COMMON", null);
            }
            this.comboSociete = new SQLRequestComboBox(false, 25);
            IComboModel model = new IComboModel(Configuration.getInstance().getDirectory().getElement(tableSociete).getComboRequest());
            int lastSociete = UserProps.getInstance().getLastSocieteID();
            if (lastSociete >= 0) {
                model.setValue(lastSociete);
            } else {
                model.setFirstFillSelection(new ITransformer<List<IComboSelectionItem>, IComboSelectionItem>(){

                    @Override
                    public IComboSelectionItem transformChecked(List<IComboSelectionItem> input) {
                        return CollectionUtils.getFirst(input);
                    }
                });
            }
            this.comboSociete.uiInit(model);
            this.comboSociete.addEmptyListener(new EmptyListener(){

                @Override
                public void emptyChange(EmptyObj src, boolean newValue) {
                    ConnexionPanel.this.checkValidity();
                }
            });
            this.comboSociete.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ConnexionPanel.this.checkValidity();
                }
            });
            ++c.gridx;
            this.add((Component)this.comboSociete, c);
        }
        JPanel panelButton = new JPanel();
        panelButton.setOpaque(false);
        panelButton.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
        c2.weightx = 1.0;
        if (allowStoredPass) {
            this.saveCheckBox.setOpaque(false);
            panelButton.add((Component)this.saveCheckBox, c2);
            c2.weightx = 0.0;
            if (storedPassword != null && storedPassword.length() > 0) {
                this.saveCheckBox.setSelected(true);
            }
        }
        ++c2.gridx;
        this.reloadPanel = new ReloadPanel();
        this.reloadPanel.setOpaque(false);
        this.reloadPanel.setMode(2);
        panelButton.add((Component)this.reloadPanel, c2);
        ++c2.gridx;
        c2.weightx = 0.0;
        this.buttonConnect.setOpaque(false);
        panelButton.add((Component)this.buttonConnect, c2);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 0;
        c.weighty = 1.0;
        this.add((Component)panelButton, c);
        this.buttonConnect.addActionListener(this);
        this.checkValidity();
    }

    private void checkValidity() {
        this.buttonConnect.setEnabled(this.connectionAllowed == null && this.areFieldsValidated());
        this.buttonConnect.setToolTipText(this.connectionAllowed);
    }

    private boolean areFieldsValidated() {
        SQLRow selectedRow;
        if (this.societeSelector && ((selectedRow = this.comboSociete.getSelectedRow()) == null || !selectedRow.isData())) {
            return false;
        }
        if (this.textLogin == null || this.textLogin.isEmpty() || this.textPassWord == null) {
            return false;
        }
        return this.textLogin.isValidated();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isConnecting()) {
            return;
        }
        if (this.textLogin.getValue().length() < 1) {
            return;
        }
        this.setConnecting(true);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                ConnexionPanel.this.connect();
            }
        });
        t.setName("ConnexionPanel Login");
        t.setPriority(1);
        t.start();
    }

    public void setConnectionAllowed(String connectionAllowed) {
        this.connectionAllowed = connectionAllowed;
        this.checkValidity();
    }

    private synchronized boolean isConnecting() {
        return this.isConnecting;
    }

    private synchronized void setConnecting(boolean b) {
        if (b) {
            this.reloadPanel.setMode(0);
            this.buttonConnect.setText("Connexion...");
            this.buttonConnect.setEnabled(false);
            this.saveCheckBox.setEnabled(false);
            if (this.comboSociete != null) {
                this.comboSociete.setEnabled(false);
            }
            ((JTextField)this.textLogin.getComp()).setEditable(false);
            this.textPassWord.setEditable(false);
        } else {
            this.buttonConnect.setText("Connexion");
            this.buttonConnect.setEnabled(true);
            this.saveCheckBox.setEnabled(true);
            if (this.comboSociete != null) {
                this.comboSociete.setEnabled(true);
            }
            ((JTextField)this.textLogin.getComp()).setEditable(true);
            this.textPassWord.setEditable(true);
            this.reloadPanel.setMode(2);
        }
        this.isConnecting = b;
    }

    private void connect() {
        Tuple2<String, String> loginRes = this.clearPassword == null ? this.login.connectEnc(this.textLogin.getValue(), this.encryptedPassword) : this.login.connectClear(this.textLogin.getValue(), this.clearPassword, "\"" + this.clearPassword + "\"");
        if (loginRes.get0() == null) {
            UserProps.getInstance().setLastLoginName(this.textLogin.getValue());
            if (this.societeSelector) {
                UserProps.getInstance().setLastSocieteID(this.comboSociete.getSelectedId());
            }
            if (this.saveCheckBox.isSelected()) {
                UserProps.getInstance().setEncryptedStoredPassword(loginRes.get1());
            } else {
                UserProps.getInstance().setEncryptedStoredPassword(null);
            }
            UserProps.getInstance().store();
            this.r.run();
            SwingUtilities.getWindowAncestor(this).dispose();
        } else {
            this.unlockUIOnError(loginRes.get0());
        }
    }

    private void unlockUIOnError(final String error) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConnexionPanel.this.reloadPanel.setMode(1);
                JOptionPane.showMessageDialog(ConnexionPanel.this, error);
                if ("Utilisateur inconnu".equals(error)) {
                    ConnexionPanel.this.textLogin.setValue(ConnexionPanel.LOGIN_ADMIN);
                }
                ConnexionPanel.this.setConnecting(false);
            }
        });
    }

    public int getSelectedSociete() {
        return this.comboSociete.getSelectedId();
    }
}

