/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.sqlobject.itemview;

import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.sqlobject.itemview.VWRowItemView;
import org.openconcerto.sql.ui.IPolyCombo;
import org.openconcerto.ui.valuewrapper.ValueWrapperFromVO;

public class PolyComboRIV
extends VWRowItemView<SQLRow> {
    public PolyComboRIV(IPolyCombo poly) {
        super(new ValueWrapperFromVO<SQLRow>(poly));
    }

    @Override
    public SQLField getField() {
        return this.getFields().get(0);
    }

    @Override
    public void resetValue() {
        this.getPolyCombo().resetValue();
    }

    @Override
    public void setEditable(boolean b) {
        this.getComp().setEnabled(b);
    }

    public String describe() {
        return String.valueOf(this.getComp().getClass().getName()) + " on " + this.getFields();
    }

    @Override
    public void show(SQLRowAccessor r) {
        if (r.getFields().contains(this.getField().getName())) {
            String tableName = r.getString(this.getTableField().getName());
            SQLRow foreignRow = tableName == null ? null : new SQLRow(r.getTable().getTable(tableName), r.getInt(this.getIdField().getName()));
            this.getWrapper().setValue(foreignRow);
        }
    }

    @Override
    public void update(SQLRowValues vals) {
        int idVal;
        String tableVal;
        if (this.getWrapper().getValue() == null) {
            tableVal = null;
            idVal = 0;
        } else {
            SQLRow r = (SQLRow)this.getWrapper().getValue();
            tableVal = r.getTable().getName();
            idVal = r.getID();
        }
        vals.put(this.getTableField().getName(), tableVal);
        vals.put(this.getIdField().getName(), idVal);
    }

    private final IPolyCombo getPolyCombo() {
        return (IPolyCombo)this.getWrapper().getComp();
    }

    private final SQLField getTableField() {
        return this.getPolyCombo().getPolymorphFK().getTableField();
    }

    private final SQLField getIdField() {
        return this.getPolyCombo().getPolymorphFK().getIdField();
    }
}

