/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.sqlobject;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.request.SQLForeignRowItemView;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.sqlobject.IComboModel;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;
import org.openconcerto.sql.sqlobject.itemview.RowItemViewComponent;
import org.openconcerto.sql.view.search.SearchSpec;
import org.openconcerto.ui.FontUtils;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.component.combo.ISearchableCombo;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.coreanimation.Pulseable;
import org.openconcerto.ui.valuewrapper.ValueChangeSupport;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.checks.EmptyChangeSupport;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.EmptyObj;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.model.DefaultIMutableListModel;

public class SQLRequestComboBox
extends JPanel
implements SQLForeignRowItemView,
ValueWrapper<Integer>,
EmptyObj,
TextComponent,
Pulseable,
RowItemViewComponent {
    public static final String UNDEFINED_STRING = "----- ??? -----";
    private IComboModel req;
    protected final ISearchableCombo<IComboSelectionItem> combo;
    private final ValueChangeSupport supp;
    private final EmptyChangeSupport emptySupp;
    private ComboMode mode;
    private ComboMode modeToSelect;
    private final String stringStuff;

    public SQLRequestComboBox() {
        this(true);
    }

    public SQLRequestComboBox(boolean addUndefined) {
        this(addUndefined, -1);
    }

    public SQLRequestComboBox(boolean addUndefined, int preferredWidthInChar) {
        this.setOpaque(false);
        this.modeToSelect = this.mode = ComboMode.EDITABLE;
        if (preferredWidthInChar > 0) {
            char[] a = new char[preferredWidthInChar];
            Arrays.fill(a, ' ');
            this.stringStuff = String.valueOf(a);
        } else {
            this.stringStuff = "123456789012345678901234567890";
        }
        this.combo = new ISearchableCombo(ComboLockedMode.LOCKED, 1, this.stringStuff.length());
        this.combo.setIncludeEmpty(addUndefined);
        this.emptySupp = new EmptyChangeSupport(this);
        this.supp = new ValueChangeSupport<Integer>(this);
    }

    public final void setFirstFillSelection(ITransformer<List<IComboSelectionItem>, IComboSelectionItem> firstFillTransf) {
        this.req.setFirstFillSelection(firstFillTransf);
    }

    @Override
    public void init(SQLRowItemView v) {
        SQLTable foreignTable = v.getField().getDBSystemRoot().getGraph().getForeignTable(v.getField());
        this.uiInit(Configuration.getInstance().getDirectory().getElement(foreignTable).getComboRequest());
    }

    public final void uiInit(ComboSQLRequest req) {
        this.uiInit(new IComboModel(req));
    }

    public final void uiInit(IComboModel req) {
        if (this.req != null) {
            throw new IllegalStateException(this + " already inited.");
        }
        this.req = req;
        this.req.addListener("updating", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SQLRequestComboBox.this.updatingChanged((Boolean)evt.getNewValue());
            }
        });
        this.req.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SQLRequestComboBox.this.modelValueChanged();
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 2L) != 0L) {
                    SQLRequestComboBox.this.updateListeners();
                }
            }
        });
        this.updateListeners();
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                SQLRequestComboBox.this.req.setOnScreen(true);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                SQLRequestComboBox.this.req.setOnScreen(false);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        FontUtils.setFontFor(this.combo, "ComboBox", this.getRequest().getSeparatorsChars());
        int i = 0;
        while (i < this.combo.getUI().getAccessibleChildrenCount(this.combo)) {
            Accessible acc = this.combo.getUI().getAccessibleChild(this.combo, i);
            if (acc instanceof ComboPopup) {
                ComboPopup cp = (ComboPopup)((Object)acc);
                cp.getList().setPrototypeCellValue(new IComboSelectionItem(-1, this.stringStuff));
            }
            ++i;
        }
        this.combo.setIconFactory(new ITransformer<IComboSelectionItem, Icon>(){

            @Override
            public Icon transformChecked(IComboSelectionItem input) {
                return SQLRequestComboBox.this.getIconFor(input);
            }
        });
        this.combo.initCache(this.req);
        this.combo.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SQLRequestComboBox.this.comboValueChanged();
            }
        });
        this.modelValueChanged();
        this.uiLayout();
        this.req.setRunning(true);
    }

    private final void updatingChanged(Boolean newValue) {
        if (Boolean.TRUE.equals(newValue)) {
            this.modeToSelect = this.getEnabled();
            this.setEnabled(ComboMode.DISABLED, true);
        } else {
            this.setEnabled(this.modeToSelect);
        }
    }

    public final List<Action> getActions() {
        return this.combo.getActions();
    }

    protected void updateListeners() {
        if (this.req != null) {
            this.req.setRunning(this.isDisplayable());
        }
    }

    public final ComboSQLRequest getRequest() {
        return this.req.getRequest();
    }

    protected void uiLayout() {
        this.setLayout(new GridLayout(1, 1));
        this.add(this.combo);
    }

    public void setDebug(boolean trace) {
        this.req.setDebug(trace);
        this.combo.setDebug(trace);
    }

    public final void setSleepAllowed(boolean sleepAllowed) {
        this.req.setSleepAllowed(sleepAllowed);
    }

    public final boolean isSleepAllowed() {
        return this.req.isSleepAllowed();
    }

    public final synchronized void fillCombo() {
        this.fillCombo(null);
    }

    public final synchronized void fillCombo(Runnable r) {
        this.req.fillCombo(r);
    }

    public final List<IComboSelectionItem> getItems() {
        return this.getComboModel().getList();
    }

    private DefaultIMutableListModel<IComboSelectionItem> getComboModel() {
        return (DefaultIMutableListModel)this.combo.getCache();
    }

    public final IComboSelectionItem getItem(int id) {
        return this.req.getItem(id);
    }

    @Override
    public final void resetValue() {
        this.setValue((Integer)null);
    }

    @Override
    public final void setValue(int id) {
        this.req.setValue(id);
    }

    @Override
    public final void setValue(Integer id) {
        if (id == null) {
            this.setValue(-1);
        } else {
            this.setValue((int)id);
        }
    }

    @Override
    public final void setValue(SQLRowAccessor r) {
        this.setValue(r == null ? null : Integer.valueOf(r.getID()));
    }

    @Override
    public final Integer getValue() {
        IComboSelectionItem o = (IComboSelectionItem)this.req.getSelectedItem();
        if (o != null && o.getId() >= 0) {
            return o.getId();
        }
        return null;
    }

    @Override
    public final int getSelectedId() {
        return this.req.getSelectedId();
    }

    public final SQLRow getSelectedRow() {
        if (this.isEmpty()) {
            return null;
        }
        return this.req.getSelectedRow();
    }

    private void modelValueChanged() {
        IComboSelectionItem newValue = this.req.getValue();
        if (this.combo.getValue() != newValue) {
            this.combo.setValue(newValue);
        }
    }

    private final void comboValueChanged() {
        this.req.setValue(this.combo.getValue());
        this.supp.fireValueChange();
        this.emptySupp.fireEmptyChange(this.isEmpty());
    }

    public final boolean addMissingItem() {
        return this.req.addMissingItem();
    }

    public final void setAddMissingItem(boolean addMissingItem) {
        this.req.setAddMissingItem(addMissingItem);
    }

    public final void setEditable(boolean b) {
        this.setEnabled(b ? ComboMode.EDITABLE : ComboMode.ENABLED);
    }

    @Override
    public final void setEnabled(boolean b) {
        this.setEnabled(b ? ComboMode.EDITABLE : ComboMode.ENABLED);
    }

    public final void setEnabled(ComboMode mode) {
        this.setEnabled(mode, false);
    }

    private final void setEnabled(ComboMode mode, boolean priv) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!priv && this.isUpdating()) {
            this.modeToSelect = mode;
        } else {
            this.mode = mode;
            this.modeChanged(mode);
        }
    }

    protected void modeChanged(ComboMode mode) {
        this.combo.setEnabled(mode == ComboMode.EDITABLE);
    }

    public final ComboMode getEnabled() {
        return this.mode;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + " " + this.req;
    }

    @Override
    public final boolean isEmpty() {
        return this.req == null || this.req.isEmpty();
    }

    @Override
    public final void addEmptyListener(EmptyListener l) {
        this.emptySupp.addEmptyListener(l);
    }

    @Override
    public final void addValueListener(PropertyChangeListener l) {
        this.supp.addValueListener(l);
    }

    @Override
    public final void rmValueListener(PropertyChangeListener l) {
        this.supp.rmValueListener(l);
    }

    public final void addItemsListener(PropertyChangeListener l) {
        this.addItemsListener(l, false);
    }

    public final void addItemsListener(PropertyChangeListener l, boolean all) {
        this.req.addItemsListener(l, all);
    }

    public final void rmItemsListener(PropertyChangeListener l) {
        this.req.rmItemsListener(l);
    }

    @Override
    public final boolean isValidated() {
        return this.combo.isValidated();
    }

    @Override
    public final void addValidListener(ValidListener l) {
        this.supp.addValidListener(l);
    }

    @Override
    public void removeValidListener(ValidListener l) {
        this.supp.removeValidListener(l);
    }

    @Override
    public String getValidationText() {
        return null;
    }

    private Icon getIconFor(IComboSelectionItem value) {
        int flag;
        ImageIcon i = value == null ? null : ((flag = value.getFlag()) == 1 ? new ImageIcon(this.getClass().getResource("warning.png")) : (flag == 2 ? new ImageIcon(this.getClass().getResource("error.png")) : null));
        return i;
    }

    @Override
    public final JComponent getComp() {
        return this;
    }

    @Override
    public JTextComponent getTextComp() {
        return this.combo.getTextComp();
    }

    @Override
    public Component getPulseComponent() {
        return this.combo;
    }

    public final void search(SearchSpec spec) {
        this.req.search(spec);
    }

    public final boolean isUpdating() {
        return this.req.isUpdating();
    }

    public static enum ComboMode {
        DISABLED,
        ENABLED,
        EDITABLE;

    }
}

