/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.sqlobject;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.sqlobject.itemview.RowItemViewComponent;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.valuewrapper.ValueChangeSupport;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.ui.warning.JLabelWarning;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.doc.Documented;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class JUniqueTextField
extends JPanel
implements ValueWrapper<String>,
Documented,
TextComponent,
RowItemViewComponent,
MouseListener {
    private JTextField textField;
    private JLabelWarning labelWarning;
    private int idSelected = -1;
    private SQLField field;
    private final ValueChangeSupport<String> supp;
    protected boolean gained;
    protected boolean mousePressed;
    protected String initialText;
    protected boolean isValidated = false;
    boolean loop = true;
    Thread validationThread = null;
    List<String> textToCheck = new Vector<String>();
    private long lastCheck;
    private int waitTime = 10000;

    public JUniqueTextField() {
        this(-1);
    }

    public JUniqueTextField(int col) {
        this.supp = new ValueChangeSupport<String>(this);
        this.textField = col > 0 ? new JTextField(col) : new JTextField();
        this.labelWarning = new JLabelWarning();
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 1.0;
        if (System.getProperties().getProperty("os.name").toLowerCase().contains("linux")) {
            this.textField.setOpaque(false);
        }
        this.setOpaque(false);
        this.add((Component)this.textField, c);
        c.insets = new Insets(0, 0, 0, 0);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)this.labelWarning, c);
        this.labelWarning.setToolTipText("Cette valeur est d\u00e9j\u00e0 affect\u00e9e.");
        this.labelWarning.addMouseListener(this);
        this.textField.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                JUniqueTextField.this.textModified();
            }
        });
        this.startChecking();
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent arg0) {
                JUniqueTextField.this.loop = true;
                JUniqueTextField.this.startChecking();
            }

            @Override
            public void ancestorMoved(AncestorEvent arg0) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent arg0) {
                JUniqueTextField.this.loop = false;
            }
        });
        this.setPreferredSize(new Dimension(this.getPreferredSize()));
    }

    private void startChecking() {
        if (this.validationThread != null && this.validationThread.isAlive()) {
            return;
        }
        this.validationThread = new Thread(){

            @Override
            public void run() {
                while (JUniqueTextField.this.loop) {
                    try {
                        JUniqueTextField.this.checkValidation();
                    }
                    catch (RTInterruptedException rTInterruptedException) {
                        // empty catch block
                    }
                    try {
                        3.sleep(JUniqueTextField.this.waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        };
        this.validationThread.setPriority(1);
        this.validationThread.setName("JUniqueTextField Watcher");
        this.validationThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean checkValidation() throws RTInterruptedException {
        int textSize;
        String t = null;
        List<String> list = this.textToCheck;
        synchronized (list) {
            if (!this.textToCheck.isEmpty()) {
                t = this.textToCheck.get(0);
            }
        }
        if (t == null) {
            t = this.getText().trim();
        }
        if ((textSize = t.length()) == 0) {
            this.isValidated = true;
            return false;
        }
        if (System.currentTimeMillis() - this.lastCheck < 1000L) {
            this.waitTime = 1000;
            return this.isValidated;
        }
        this.lastCheck = System.currentTimeMillis();
        if (this.getTable() != null) {
            boolean b;
            SQLSelect selNum = new SQLSelect(this.getTable().getBase());
            selNum.addSelect(this.getTable().getKey(), "COUNT");
            Where w = new Where((FieldRef)this.getField(), "=", (Object)t);
            selNum.setWhere(w);
            if (this.idSelected > 1) {
                selNum.andWhere(new Where((FieldRef)this.getTable().getKey(), "!=", this.idSelected));
            }
            String req = selNum.asString();
            Number l = (Number)this.getTable().getBase().getDataSource().execute(req, new IResultSetHandler(SQLDataSource.SCALAR_HANDLER, false));
            this.isValidated = b = l.intValue() <= 0;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JUniqueTextField.this.setValidated(b);
                    boolean isRed = JUniqueTextField.this.labelWarning.isRed();
                    JUniqueTextField.this.labelWarning.setColorRed(!isRed);
                    JUniqueTextField.this.supp.fireValueChange();
                }
            });
            this.waitTime = 10000;
            return b;
        }
        return this.isValidated;
    }

    protected void textModified() {
        this.waitTime = 1000;
        this.runValidationThread();
    }

    @Override
    public void init(SQLRowItemView v) {
        this.field = v.getField();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JUniqueTextField.this.gained = true;
                JUniqueTextField.this.initialText = JUniqueTextField.this.textField.getText();
                if (!JUniqueTextField.this.mousePressed) {
                    JUniqueTextField.this.textField.selectAll();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JUniqueTextField.this.mousePressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (JUniqueTextField.this.gained && JUniqueTextField.this.textField.getSelectedText() == null) {
                    JUniqueTextField.this.textField.selectAll();
                }
                JUniqueTextField.this.gained = false;
                JUniqueTextField.this.mousePressed = false;
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u001b') {
                    JUniqueTextField.this.setValue(JUniqueTextField.this.initialText);
                    JUniqueTextField.this.textField.selectAll();
                }
            }
        });
    }

    public SQLField getField() {
        return this.field;
    }

    @Override
    public void setValue(String val) {
        if (!this.textField.getText().equals(val)) {
            this.textField.setText(val);
        }
    }

    @Override
    public void resetValue() {
        this.setValue("");
    }

    public SQLTable getTable() {
        if (this.field == null) {
            return null;
        }
        return this.field.getTable();
    }

    @Override
    public String toString() {
        return "JUniqueTextField on " + this.field;
    }

    public void setEditable(boolean b) {
        this.textField.setEditable(b);
    }

    @Override
    public String getValue() throws IllegalStateException {
        return this.textField.getText();
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addValueListener(l);
    }

    @Override
    public synchronized boolean isValidated() {
        return this.isValidated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void runValidationThread() {
        if (!this.textToCheck.isEmpty()) {
            this.textToCheck.clear();
        }
        this.textToCheck.add(this.getText().trim());
        Thread thread = this.validationThread;
        synchronized (thread) {
            this.validationThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setValidated(final boolean b) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException();
        }
        JUniqueTextField jUniqueTextField = this;
        synchronized (jUniqueTextField) {
            if (b != this.isValidated) {
                this.isValidated = b;
                this.supp.fireValueChange();
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JUniqueTextField.this.labelWarning.setVisible(!b);
                if (!b) {
                    JUniqueTextField.this.showTooltip();
                }
            }
        });
    }

    private void showTooltip() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Sould be called in EDT");
        }
        ToolTipManager.sharedInstance().mouseMoved(new MouseEvent(this.labelWarning, 0, 0L, 0, 0, 0, 0, false));
    }

    public void setText(String s) {
        this.textField.setText(s);
    }

    public String getText() {
        return this.textField.getText();
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public void setIdSelected(int id) {
        this.idSelected = id;
        this.isValidated = true;
        this.supp.fireValueChange();
    }

    @Override
    public String getDocId() {
        return "UT_" + this.field.getFullName();
    }

    @Override
    public String getGenericDoc() {
        return "";
    }

    @Override
    public boolean onScreen() {
        return true;
    }

    @Override
    public boolean isDocTransversable() {
        return false;
    }

    @Override
    public String getValidationText() {
        return "Le num\u00e9ro existe d\u00e9j\u00e0";
    }

    @Override
    public JTextComponent getTextComp() {
        return this.textField;
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.supp.addValidListener(l);
    }

    @Override
    public void removeValidListener(ValidListener l) {
        this.supp.removeValidListener(l);
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.supp.rmValueListener(l);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

