/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.sqlobject;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableListener;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;
import org.openconcerto.sql.view.IListener;
import org.openconcerto.ui.FontUtils;
import org.openconcerto.utils.model.ListComboBoxModel;

public class IComboBox
extends JComboBox
implements SQLTableListener {
    private final ComboSQLRequest fillFromReq;
    private final Set listeners = new HashSet();
    private boolean updating = false;

    public IComboBox(final ComboSQLRequest fillFromReq) {
        this.fillFromReq = fillFromReq;
        this.fillFromReq.getPrimaryTable().addTableListener(this);
        FontUtils.setFontFor(this, fillFromReq.getSeparatorsChars());
        final ListCellRenderer oldRenderer = this.getRenderer();
        this.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component res = oldRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                FontUtils.setFontFor(res, "ComboBox", fillFromReq.getSeparatorsChars());
                return res;
            }
        });
        this.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                2 var2_2 = this;
                synchronized (var2_2) {
                    if (!IComboBox.this.updating) {
                        IComboBox.this.fireSelection();
                    }
                }
            }
        });
        this.setMaximumRowCount(30);
        this.setPreferredSize(new Dimension(600, 22));
        this.setModel(new ListComboBoxModel());
    }

    public synchronized void fillComboFromRequest() {
        this.updating = true;
        this.getListModel().removeAllElements();
        List<IComboSelectionItem> v = this.fillFromReq.getComboItems();
        this.getListModel().addAll(v);
        this.updating = false;
    }

    public synchronized void removeItems(int[] toRemove, int toRemoveCount) {
        this.updating = true;
        int i = toRemoveCount - 1;
        while (i >= 0) {
            int indexToRemove = toRemove[i];
            this.getListModel().removeElementAt(indexToRemove);
            --i;
        }
        this.updating = false;
    }

    public ListComboBoxModel getListModel() {
        return (ListComboBoxModel)this.getModel();
    }

    public int getSelectedId() {
        IComboSelectionItem item = (IComboSelectionItem)this.getSelectedItem();
        return item == null ? -1 : item.getId();
    }

    public synchronized void setSelectedId(int id) {
        int i = 0;
        while (i < this.getItemCount()) {
            IComboSelectionItem obj = (IComboSelectionItem)this.getItemAt(i);
            if (obj.getId() == id) {
                this.setSelectedItem(obj);
            }
            ++i;
        }
    }

    @Override
    public String toString() {
        return this.getSelectedItem() + "(" + this.getSelectedId() + ")";
    }

    public void selectNext() {
        int i = this.getSelectedIndex();
        if (i < this.getItemCount() - 1) {
            this.setSelectedIndex(i + 1);
        }
    }

    public void selectPrevious() {
        int i = this.getSelectedIndex();
        if (i > 0) {
            this.setSelectedIndex(i - 1);
        }
    }

    @Override
    public void rowModified(SQLTable table, int id) {
        this.fillComboFromRequest();
    }

    @Override
    public void rowAdded(SQLTable table, int id) {
        this.fillComboFromRequest();
    }

    @Override
    public void rowDeleted(SQLTable table, int id) {
        this.fillComboFromRequest();
    }

    public synchronized void addIListener(IListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeIListener(IListener listener) {
        this.listeners.remove(listener);
    }

    private synchronized void fireSelection() {
        for (IListener l : this.listeners) {
            l.selectionId(this.getSelectedId(), -1);
        }
    }

    @Override
    public void setEditable(boolean b) {
        if (b) {
            super.setEditable(b);
        }
        super.setEnabled(b);
    }

    public final ComboSQLRequest getRequest() {
        return this.fillFromReq;
    }
}

