/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.RowItemDesc;
import org.openconcerto.utils.CollectionUtils;

public class SQLFieldTranslator {
    private static final RowItemDesc NULL_DESC = new RowItemDesc(null, null);
    private final Map<SQLTable, Map<String, RowItemDesc>> translation = new HashMap<SQLTable, Map<String, RowItemDesc>>();
    private final SQLElementDirectory dir;

    public SQLFieldTranslator(DBRoot base, File file) {
        this.load(base, file);
        this.dir = null;
    }

    public SQLFieldTranslator(DBRoot base, InputStream inputStream) {
        this(base, inputStream, null);
    }

    public SQLFieldTranslator(DBRoot root, InputStream inputStream, SQLElementDirectory dir) {
        this.dir = dir;
        this.load(root, inputStream);
    }

    public void putAll(SQLFieldTranslator o) {
        CollectionUtils.addIfNotPresent(this.translation, o.translation);
    }

    public void load(DBRoot b, File file) {
        try {
            this.load(b, new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static List<Element> getChildren(Element elem) {
        return elem.getChildren();
    }

    public void load(DBRoot b, InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is null");
        }
        try {
            Document doc = new SAXBuilder().build(inputStream);
            for (Element elem : SQLFieldTranslator.getChildren(doc.getRootElement())) {
                String elemName = elem.getName().toLowerCase();
                if (elemName.equals("table")) {
                    this.load(b, elem);
                    continue;
                }
                if (!elemName.equals("root")) continue;
                DBRoot root = b.getDBSystemRoot().getRoot(elem.getAttributeValue("name"));
                for (Element tableElem : SQLFieldTranslator.getChildren(elem)) {
                    this.load(root, tableElem);
                }
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void load(DBRoot b, Element tableElem) {
        String tableName = tableElem.getAttributeValue("name");
        SQLTable table = b.getTable(tableName);
        if (table == null && this.dir != null && this.dir.getElement(tableName) != null) {
            table = this.dir.getElement(tableName).getTable();
        }
        if (table == null) {
            Log.get().info("unknown table " + tableName);
        } else {
            for (Element fieldElem : SQLFieldTranslator.getChildren(tableElem)) {
                String name = fieldElem.getAttributeValue("name");
                String label = fieldElem.getAttributeValue("label");
                String title = fieldElem.getAttributeValue("titlelabel", label);
                String documentation = fieldElem.getText();
                this.putTranslation(table, name, new RowItemDesc(label, title, documentation));
            }
        }
    }

    private final Map<String, RowItemDesc> getMap(SQLTable t) {
        Map<String, RowItemDesc> m = this.translation.get(t);
        if (m == null) {
            m = new HashMap<String, RowItemDesc>();
            this.translation.put(t, m);
        }
        return m;
    }

    private final void putTranslation(SQLTable t, String name, RowItemDesc desc) {
        this.getMap(t).put(name, desc);
    }

    private final RowItemDesc getTranslation(SQLTable t, String name) {
        return this.getMap(t).get(name);
    }

    public RowItemDesc getDescFor(SQLTable t, String name) {
        String fullName = String.valueOf(t.getName()) + "." + name;
        RowItemDesc labeledField = this.getTranslation(t, name);
        if (labeledField == null) {
            String l = name.replaceAll("ID_", "").replaceAll("_", " de ");
            if (l.length() > 1) {
                l = String.valueOf(l.substring(0, 1).toUpperCase()) + l.substring(1).toLowerCase();
            }
            l = l.trim();
            System.err.println("No translation for:" + fullName + "\n please add: <FIELD name=\"" + name + "\" label=\"" + l + "\" titlelabel=\"" + l + "\"/>");
        }
        return labeledField == null ? NULL_DESC : labeledField;
    }

    private RowItemDesc getDescFor(SQLField f) {
        return this.getDescFor(f.getTable(), f.getName());
    }

    public String getLabelFor(SQLField f) {
        return this.getDescFor(f).getLabel();
    }

    public String getTitleFor(SQLField f) {
        return this.getDescFor(f).getTitleLabel();
    }
}

