/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.preferences;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.CollectionUtils;

public class SQLPreferences
extends AbstractPreferences {
    private static final String PREF_NODE_TABLENAME = "PREF_NODE";
    private static final String PREF_VALUE_TABLENAME = "PREF_VALUE";
    private final SQLTable prefT;
    private final SQLTable nodeT;
    private Map<String, String> values;
    private final Map<String, String> changedValues;
    private final Set<String> removedKeys;
    private SQLRow node;

    public static SQLTable getPrefTable(final DBRoot root) throws SQLException {
        if (!root.contains(PREF_VALUE_TABLENAME)) {
            final SQLDataSource ds = root.getDBSystemRoot().getDataSource();
            SQLUtils.executeAtomic(ds, new SQLUtils.SQLFactory<Object>(){

                @Override
                public Object create() throws SQLException {
                    SQLCreateTable createNodeT = new SQLCreateTable(root, SQLPreferences.PREF_NODE_TABLENAME);
                    createNodeT.setPlain(true);
                    createNodeT.addColumn("ID", createNodeT.getSyntax().getPrimaryIDDefinition());
                    createNodeT.addColumn("ID_PARENT", String.valueOf(createNodeT.getSyntax().getIDType()) + " NULL");
                    createNodeT.addVarCharColumn("NAME", 80);
                    createNodeT.addForeignConstraint("ID_PARENT", new SQLName(createNodeT.getName()), "ID");
                    createNodeT.addUniqueConstraint("uniqNamePerParent", Arrays.asList("ID_PARENT", "NAME"));
                    SQLCreateTable createValueT = new SQLCreateTable(root, SQLPreferences.PREF_VALUE_TABLENAME);
                    createValueT.setPlain(true);
                    createValueT.addColumn("ID_NODE", String.valueOf(createValueT.getSyntax().getIDType()) + " NOT NULL");
                    createValueT.addVarCharColumn("NAME", 80);
                    createValueT.addVarCharColumn("VALUE", 8192);
                    createValueT.setPrimaryKey("ID_NODE", "NAME");
                    createValueT.addForeignConstraint("ID_NODE", new SQLName(createNodeT.getName()), "ID");
                    SQLCreateTable[] sQLCreateTableArray = new SQLCreateTable[]{createNodeT, createValueT};
                    int n = sQLCreateTableArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SQLCreateTable ct = sQLCreateTableArray[n2];
                        ds.execute(ct.asString());
                        SQLTable.setUndefID(root.getSchema(), ct.getName(), null);
                        ++n2;
                    }
                    root.getSchema().updateVersion();
                    return null;
                }
            });
            root.refetch();
        }
        return root.getTable(PREF_VALUE_TABLENAME);
    }

    public SQLPreferences(DBRoot db) {
        this(null, "", db);
    }

    private SQLPreferences(SQLPreferences parent, String name, DBRoot db) {
        super(parent, name);
        if (db == null) {
            throw new IllegalArgumentException("Missing DBRoot");
        }
        this.prefT = db.getTable(PREF_VALUE_TABLENAME);
        this.nodeT = this.prefT.getForeignTable("ID_NODE");
        this.values = null;
        this.changedValues = new HashMap<String, String>();
        this.removedKeys = new HashSet<String>();
        this.node = null;
    }

    private final SQLDataSource getDS() {
        return this.prefT.getDBSystemRoot().getDataSource();
    }

    private Object execute(String sel, ResultSetHandler rsh) {
        return this.getDS().execute(sel, new IResultSetHandler(rsh, false));
    }

    public final SQLRow getNode() {
        try {
            return this.getNode(false);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public final SQLRow getNode(boolean create) throws SQLException {
        if (this.node == null) {
            Where parentW;
            SQLPreferences parent = (SQLPreferences)this.parent();
            if (parent == null) {
                parentW = Where.isNull(this.nodeT.getField("ID_PARENT"));
            } else {
                SQLRow parentNode = parent.getNode(create);
                Where where = parentW = parentNode == null ? null : new Where((FieldRef)this.nodeT.getField("ID_PARENT"), "=", parentNode.getID());
            }
            if (parentW == null) {
                this.node = null;
            } else {
                SQLSelect sel = new SQLSelect(this.nodeT.getBase()).addSelectStar(this.nodeT);
                sel.setWhere(parentW.and(new Where((FieldRef)this.nodeT.getField("NAME"), "=", (Object)this.name())));
                Map m = (Map)this.execute(sel.asString(), SQLDataSource.MAP_HANDLER);
                SQLRow sQLRow = this.node = m == null ? null : new SQLRow(this.nodeT, m);
            }
            if (this.node == null && create) {
                SQLRowValues insVals = new SQLRowValues(this.nodeT);
                insVals.put("ID_PARENT", parent == null ? null : Integer.valueOf(parent.getNode(create).getID()));
                insVals.put("NAME", this.name());
                this.node = insVals.insert();
            }
        }
        return this.node;
    }

    public final Map<String, String> getValues() {
        if (this.values == null) {
            this.values = new HashMap<String, String>();
            SQLRow node = this.getNode();
            if (node != null) {
                SQLSelect sel = new SQLSelect(this.prefT.getBase()).addSelectStar(this.prefT);
                sel.setWhere(new Where((FieldRef)this.prefT.getField("ID_NODE"), "=", node.getID()));
                List l = (List)this.execute(sel.asString(), SQLDataSource.MAP_LIST_HANDLER);
                for (Map r : l) {
                    this.values.put(r.get("NAME").toString(), r.get("VALUE").toString());
                }
            }
        }
        return this.values;
    }

    @Override
    protected void putSpi(String key, String value) {
        this.changedValues.put(key, value);
        this.removedKeys.remove(key);
    }

    @Override
    protected void removeSpi(String key) {
        this.removedKeys.add(key);
        this.changedValues.remove(key);
    }

    @Override
    protected String getSpi(String key) {
        if (this.removedKeys.contains(key)) {
            return null;
        }
        if (this.changedValues.containsKey(key)) {
            return this.changedValues.get(key);
        }
        return this.getValues().get(key);
    }

    private void deleteValues(Set<String> keys) {
        SQLRow node = this.getNode();
        if (node != null) {
            String keysW = keys == null ? "" : " and " + new Where(this.prefT.getField("NAME"), keys).getClause();
            this.getDS().execute("DELETE FROM " + this.prefT.getSQLName().quote() + " where \"ID_NODE\" = " + node.getID() + keysW);
        }
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        try {
            SQLRow node = this.getNode();
            if (node != null) {
                this.deleteValues(null);
                this.getDS().execute("DELETE FROM " + this.nodeT.getSQLName().quote() + " where \"ID\" = " + node.getID());
                this.node = null;
            }
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
        assert (this.node == null);
        this.values = null;
        this.removedKeys.clear();
        this.changedValues.clear();
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        try {
            Set<String> res;
            Set<String> committedKeys = this.getValues().keySet();
            if (this.removedKeys.isEmpty() && this.changedValues.isEmpty()) {
                res = committedKeys;
            } else {
                res = new HashSet<String>(committedKeys);
                res.removeAll(this.removedKeys);
                res.addAll(this.changedValues.keySet());
            }
            return res.toArray(new String[res.size()]);
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        try {
            SQLRow node = this.getNode();
            if (node == null) {
                return new String[0];
            }
            int nodeID = node.getID();
            SQLSelect sel = new SQLSelect(this.nodeT.getBase()).addSelect(this.nodeT.getField("NAME"));
            Where w = new Where((FieldRef)this.nodeT.getField("ID_PARENT"), "=", nodeID);
            sel.setWhere(w);
            List names = (List)this.execute(sel.asString(), SQLDataSource.COLUMN_LIST_HANDLER);
            return names.toArray(new String[names.size()]);
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
    }

    @Override
    protected SQLPreferences childSpi(String name) {
        return new SQLPreferences(this, name, this.prefT.getDBRoot());
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
        this.flushSpi();
        this.values = null;
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
        if (this.removedKeys.size() > 0 || this.changedValues.size() > 0) {
            try {
                this.deleteValues(CollectionUtils.union(this.removedKeys, this.changedValues.keySet()));
                this.removedKeys.clear();
                if (this.changedValues.size() > 0) {
                    int nodeID = this.getNode(true).getID();
                    ArrayList<String> insValues = new ArrayList<String>(this.changedValues.size());
                    for (Map.Entry<String, String> e : this.changedValues.entrySet()) {
                        insValues.add("(" + nodeID + ", " + this.prefT.getBase().quoteString(e.getKey()) + ", " + this.prefT.getBase().quoteString(e.getValue()) + ")");
                    }
                    SQLRowValues.insertCount(this.prefT, "(\"ID_NODE\", \"NAME\", \"VALUE\") VALUES" + CollectionUtils.join(insValues, ", "));
                    this.changedValues.clear();
                }
            }
            catch (Exception e) {
                throw new BackingStoreException(e);
            }
        }
    }
}

