/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.navigator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.laf.LAFUtils;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.navigator.ListStateModel;
import org.openconcerto.sql.navigator.RowsSQLBrowserColumn;
import org.openconcerto.sql.navigator.RowsSQLListModel;
import org.openconcerto.sql.navigator.SQLBrowser;
import org.openconcerto.sql.navigator.SQLListModel;
import org.openconcerto.sql.navigator.VerticalTextColumn;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.KeyLabel;
import org.openconcerto.ui.list.selection.ListSelectionState;
import org.openconcerto.utils.JImage;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.utils.text.SimpleDocumentListener;

public abstract class SQLBrowserColumn<T, L extends SQLListModel<T>>
extends JPanel {
    private static final long serialVersionUID = 3340938099896864844L;
    private static final Icon iconUp = new ImageIcon(LAFUtils.class.getResource("up.png"));
    private static final Icon iconDown = new ImageIcon(LAFUtils.class.getResource("down.png"));
    private static final Font fontText = new Font("Tahoma", 0, 11);
    private final L model;
    private boolean minimized;
    protected SQLBrowser parentBrowser;
    private JButton min;
    private JLabel title;
    private final JTextField search;
    private JPanel normalPanel;
    private JPanel minimizedPanel;
    protected JList list;
    final KeyLabel keyLabel = new KeyLabel("F1");
    private final PropertyChangeListener focusListener;

    public SQLBrowserColumn(L model, boolean searchable) {
        this.model = model;
        this.search = searchable ? new JTextField() : null;
        this.focusListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                boolean hasFocus = focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, SQLBrowserColumn.this);
                SQLBrowserColumn.this.focusChanged(hasFocus);
            }
        };
        this.uiInit();
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel comp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                SQLBrowserColumn.this.render(comp, value);
                return comp;
            }
        });
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                SQLBrowserColumn.this.navigate(e);
            }
        });
    }

    protected abstract String getHeaderName();

    protected void render(JLabel comp, T value) {
        if (((SQLListModel)this.getModel()).isALLValue(value)) {
            comp.setText("Tous (" + (((SQLListModel)this.getModel()).getSize() - 1) + ")");
        } else {
            comp.setText(((SQLListModel)this.getModel()).toString(value));
        }
    }

    private final void navigate(KeyEvent e) {
        if (e.getKeyCode() == 39) {
            if (this.next() != null) {
                super.selectFirstRow();
            } else if (this.list.getSelectedValue() == null) {
                this.list.setSelectedIndex(this.list.getSelectionModel().getLeadSelectionIndex());
            }
        } else if (e.getKeyCode() == 37) {
            this.deselect();
            if (this.previous() != null) {
                this.previous().setActive();
            }
        }
    }

    public final void select(boolean nextOrPrevious) {
        int selIndex = this.list.getSelectedIndex();
        if (nextOrPrevious && selIndex < this.list.getModel().getSize() - 1) {
            this.list.setSelectedIndex(selIndex + 1);
        } else if (!nextOrPrevious && selIndex > 0) {
            this.list.setSelectedIndex(selIndex - 1);
        }
        this.list.requestFocusInWindow();
    }

    private void uiInit() {
        UIManager.put("List.background", Color.WHITE);
        UIManager.put("List.selectionForeground", Color.WHITE);
        this.normalPanel = new JPanel();
        this.normalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.weighty = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 1;
        c.weightx = 0.0;
        JPanel headerPanel = this.createHeaderPanel();
        this.normalPanel.add((Component)headerPanel, c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        this.list = new JList(this.getModel());
        this.list.setSelectionModel(new ReSelectionModel());
        this.list.setFont(fontText);
        this.list.setSelectionMode(this.getSelectionMode());
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.setBorder(null);
        scrollPane.setMinimumSize(new Dimension(60, 100));
        this.normalPanel.add((Component)scrollPane, c);
        if (this.isSearchable()) {
            JPanel searchPane = this.createSearchPanel();
            c.gridwidth = 1;
            c.gridx = 0;
            c.fill = 2;
            c.weighty = 0.0;
            ++c.gridy;
            c.weightx = 0.0;
            this.normalPanel.add((Component)searchPane, c);
            this.search.getDocument().addDocumentListener(new SimpleDocumentListener(){

                @Override
                public void update(DocumentEvent e) {
                    ((SQLListModel)SQLBrowserColumn.this.getModel()).setSearchString(SQLBrowserColumn.this.search.getText());
                }
            });
        }
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SQLBrowserColumn.this.updateNextCol();
                }
            }
        });
        ((SQLListModel)this.getModel()).addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (SQLBrowserColumn.this.getParentBrowser() != null && SQLBrowserColumn.this.isVirtualSelected()) {
                    SQLBrowserColumn.this.updateNextCol();
                }
            }
        }, "items");
        this.minimizedPanel = new VerticalTextColumn(this.getHeaderName());
        this.minimizedPanel.setVisible(false);
        this.minimizedPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SQLBrowserColumn.this.getParentBrowser().maximizeFrom(SQLBrowserColumn.this);
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints cc = new GridBagConstraints();
        cc.fill = 1;
        cc.weightx = 1.0;
        cc.weighty = 1.0;
        this.add((Component)this.normalPanel, cc);
        ++cc.gridx;
        this.add((Component)this.minimizedPanel, cc);
        this.setFocusable(false);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 2L) != 0L) {
                    if (e.getChanged().isDisplayable()) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(SQLBrowserColumn.this.focusListener);
                    } else {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(SQLBrowserColumn.this.focusListener);
                    }
                }
            }
        });
        this.list.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ListSelectionModel m = SQLBrowserColumn.this.list.getSelectionModel();
                if (!m.isSelectionEmpty()) {
                    return;
                }
                int listCount = SQLBrowserColumn.this.list.getModel().getSize();
                if (m.getLeadSelectionIndex() >= listCount) {
                    if (m instanceof DefaultListSelectionModel) {
                        ((DefaultListSelectionModel)m).moveLeadSelectionIndex(listCount - 1);
                    } else {
                        m.setLeadSelectionIndex(listCount - 1);
                        m.clearSelection();
                    }
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    private JPanel createHeaderPanel() {
        JPanel headerPanel = new JPanel();
        headerPanel.setOpaque(false);
        headerPanel.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridx = 0;
        c2.fill = 2;
        c2.insets = new Insets(0, 2, 1, 4);
        c2.weightx = 0.0;
        this.min = new JButton();
        this.min.setBorder(null);
        this.min.setBorderPainted(false);
        this.min.setOpaque(false);
        this.min.setMargin(new Insets(0, 0, 0, 0));
        this.min.setContentAreaFilled(false);
        this.min.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                SQLBrowserColumn.this.getParentBrowser().minimizeUntil(SQLBrowserColumn.this);
            }
        });
        this.min.setIcon(new ImageIcon(this.getClass().getResource("minimize.png")));
        headerPanel.add((Component)this.min, c2);
        ++c2.gridx;
        this.title = new JLabel(this.getHeaderName());
        this.setTitleIcon();
        this.setOpaque(false);
        this.title.setFocusable(false);
        this.title.setFont(fontText);
        this.title.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ((SQLListModel)SQLBrowserColumn.this.getModel()).sort();
                SQLBrowserColumn.this.setTitleIcon();
            }
        });
        headerPanel.add((Component)this.title, c2);
        ++c2.gridx;
        c2.weightx = 1.0;
        this.keyLabel.setFont(this.title.getFont());
        headerPanel.add((Component)this.keyLabel, c2);
        return headerPanel;
    }

    private void setTitleIcon() {
        Icon icon;
        switch (((SQLListModel)this.getModel()).getSortDirection()) {
            case ASCENDING: {
                icon = iconUp;
                break;
            }
            case DESCENDING: {
                icon = iconDown;
                break;
            }
            default: {
                icon = null;
            }
        }
        this.title.setIcon(icon);
    }

    private JPanel createSearchPanel() {
        JPanel searchPane = new JPanel();
        searchPane.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridx = 0;
        c2.weightx = 0.0;
        c2.fill = 2;
        c2.insets = new Insets(2, 2, 1, 1);
        JImage image = new JImage(ElementComboBox.class.getResource("loupe.png"));
        searchPane.add((Component)image, c2);
        ++c2.gridx;
        c2.weightx = 1.0;
        searchPane.add((Component)this.search, c2);
        c2.weightx = 0.0;
        ++c2.gridx;
        JButton del = new JButton(new ImageIcon(BaseSQLComponent.class.getResource("delete.png")));
        del.setBorder(null);
        del.setOpaque(false);
        del.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLBrowserColumn.this.search.setText("");
            }
        });
        searchPane.add((Component)del, c2);
        return searchPane;
    }

    protected abstract int getSelectionMode();

    public void addSelectionListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener("selection", listener);
    }

    public void removeSelectionListener(PropertyChangeListener listener) {
        this.removePropertyChangeListener("selection", listener);
    }

    final void updateNextCol() {
        ArrayList groups;
        ListSelectionModel m = this.list.getSelectionModel();
        if (m.isSelectionEmpty()) {
            groups = Collections.EMPTY_LIST;
            this.selectionCleared();
            this.getParentBrowser().rmColumnAfter(this);
        } else {
            groups = new ArrayList(m.getMaxSelectionIndex() - m.getMinSelectionIndex() + 1);
            SQLBrowserColumn next = this.selectionChanged(m);
            if (next == null) {
                this.getParentBrowser().rmColumnAfter(this);
            } else if (next != this.next()) {
                this.getParentBrowser().addColumn(next, this);
            }
            final int lead = m.getLeadSelectionIndex();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SQLBrowserColumn.this.list.ensureIndexIsVisible(lead);
                }
            });
        }
        this.parentBrowser.fireSQLBrowserColumnSelected(this);
        this.firePropertyChange("selection", null, groups);
    }

    protected void selectionCleared() {
    }

    protected abstract SQLBrowserColumn selectionChanged(ListSelectionModel var1);

    public abstract void setSelectedRow(SQLRow var1);

    void setParentIDs(Collection<? extends Number> ids) {
        ListSelectionState state;
        ((SQLListModel)this.getModel()).setParentIDs(ids);
        if (this.getParentBrowser() != null && this.getSelectedRows().isEmpty() && (state = this.getSelectionState()) != null) {
            state.selectIDs(Collections.<Integer>emptySet());
        }
    }

    protected ListSelectionState getSelectionState() {
        return null;
    }

    protected final void setSelectedValue(Object o) {
        this.list.setSelectedValue(o, true);
    }

    public final boolean isAllSelected() {
        return !this.list.isSelectionEmpty() && ((SQLListModel)this.getModel()).isALLValue(this.list.getSelectedValue());
    }

    boolean isVirtualSelected() {
        return this.isAllSelected();
    }

    protected final void reload() {
        ((SQLListModel)this.getModel()).reload();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": " + this.getHeaderName() + " modelSize:" + ((SQLListModel)this.getModel()).getSize();
    }

    @Override
    public final void setTransferHandler(TransferHandler th) {
        this.list.setDragEnabled(th != null);
        this.list.setTransferHandler(th);
    }

    public final void setMinimizedState(boolean b) {
        this.normalPanel.setVisible(!b);
        this.minimizedPanel.setVisible(b);
        this.minimized = b;
    }

    public final boolean isMinimized() {
        return this.minimized;
    }

    public final SQLBrowser getParentBrowser() {
        return this.parentBrowser;
    }

    public final void deselect() {
        this.list.clearSelection();
    }

    final void setParentBrowser(SQLBrowser browser) {
        if (this.parentBrowser != null && browser != null) {
            throw new IllegalStateException("browser already set to : " + this.parentBrowser);
        }
        if (browser == null) {
            this.die();
        }
        this.parentBrowser = browser;
        if (this.parentBrowser != null) {
            this.live();
        }
    }

    protected abstract void live();

    protected abstract void die();

    public final SQLBrowserColumn<?, ?> previous() {
        int myIndex = this.parentBrowser.getColumns().indexOf(this);
        if (myIndex == 0) {
            return null;
        }
        return this.parentBrowser.getColumns().get(myIndex - 1);
    }

    public SQLBrowserColumn<?, ?> next() {
        if (this.parentBrowser.getLastColumn() == this) {
            return null;
        }
        int myIndex = this.parentBrowser.getColumns().indexOf(this);
        return this.parentBrowser.getColumns().get(myIndex + 1);
    }

    public final RowsSQLBrowserColumn previousRowsColumn() {
        return this.previousRowsColumn(false);
    }

    public final RowsSQLBrowserColumn previousRowsColumn(boolean includingThis) {
        SQLBrowserColumn<?, ?> currentCol = includingThis ? this : this.previous();
        while (currentCol != null && !(currentCol instanceof RowsSQLBrowserColumn)) {
            currentCol = currentCol.previous();
        }
        return (RowsSQLBrowserColumn)currentCol;
    }

    private void selectFirstRow() {
        if (!((SQLListModel)this.getModel()).getRealItems().isEmpty()) {
            this.list.setSelectedValue(((SQLListModel)this.getModel()).getRealItems().get(0), true);
        } else if (((SQLListModel)this.getModel()).getSize() > 0) {
            this.list.setSelectedIndex(0);
        } else {
            throw new IllegalStateException("completely empty column " + this);
        }
        this.setActive();
    }

    public final void setActive() {
        this.getParentBrowser().activate(this);
    }

    void activate() {
        if (!this.isActive()) {
            this.list.requestFocusInWindow();
        }
    }

    protected final void focusChanged(boolean gained) {
        if (gained) {
            this.normalPanel.setBackground(new Color(100, 100, 120));
            this.title.setForeground(Color.WHITE);
            this.list.setSelectionBackground(new Color(100, 100, 120));
        } else {
            this.normalPanel.setBackground(new JPanel().getBackground());
            this.title.setForeground(Color.BLACK);
            this.list.setSelectionBackground(Color.LIGHT_GRAY);
        }
        if (this.getParentBrowser() != null) {
            this.getParentBrowser().columnFocusChanged(this, gained);
        }
    }

    public final boolean isActive() {
        return this.getParentBrowser().getActiveColumn() == this;
    }

    public final void setShortcut(String string) {
        this.keyLabel.setText(string);
    }

    public abstract SQLTable getTable();

    public abstract List<Integer> getSelectedIDs();

    public abstract List<SQLRow> getSelectedRows();

    public final List<SQLRow> getUserSelectedRows() {
        RowsSQLBrowserColumn prev = this.previousRowsColumn(true);
        ListSelectionState state = prev.getSelectionState();
        if (state == null) {
            return prev.getSelectedRows();
        }
        final Set<Integer> userSelectedIDs = state.getUserSelectedIDs();
        RowsSQLListModel prevModel = (RowsSQLListModel)prev.getModel();
        final ListStateModel stateModel = prev.getStateModel();
        if (prevModel.hasALLValue() && userSelectedIDs.contains(-2)) {
            return prev.getSelectedRows();
        }
        return prevModel.selectItems(false, new IPredicate<SQLRow>(){

            @Override
            public boolean evaluateChecked(SQLRow r) {
                return userSelectedIDs.contains(stateModel.stateIDFromItem(r));
            }
        });
    }

    protected final boolean isSearchable() {
        return this.search != null;
    }

    protected final boolean isSearched() {
        return ((SQLListModel)this.getModel()).getSearch() != null && !((SQLListModel)this.getModel()).getSearch().isEmpty();
    }

    protected final L getModel() {
        return this.model;
    }

    public void setSelectionMode(int selectionMode) {
        this.list.setSelectionMode(selectionMode);
    }

    static class ReSelectionModel
    extends DefaultListSelectionModel {
        ReSelectionModel() {
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            boolean alreadySelected = this.isSelectedIndex(index0);
            super.setSelectionInterval(index0, index1);
            if (index0 == index1 && alreadySelected) {
                this.fireValueChanged(index0, index0, false);
            }
        }
    }
}

