/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.navigator;

import java.util.List;
import java.util.Set;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableListener;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.navigator.SQLListModel;

public class RowsSQLListModel
extends SQLListModel<SQLRow>
implements SQLTableListener {
    private final SQLElement element;
    private final ResultSetHandler handler;

    public RowsSQLListModel(SQLElement element) {
        this.element = element;
        this.handler = new SQLRowListRSH(this.getElement().getTable(), true);
        this.getElement().getTable().addTableListener(this);
    }

    @Override
    protected void reload() {
        Set<Number> ids = this.getIds();
        String key = this.getElement().getParentForeignField();
        SQLSelect sel = new SQLSelect(this.getElement().getTable().getBase());
        sel.addSelectStar(this.getElement().getTable());
        sel.addOrderSilent(this.getElement().getTable().getName());
        if (ids != null && key != null) {
            sel.setWhere(new Where(this.getElement().getTable().getField(key), ids));
        }
        SQLDataSource source = this.getElement().getTable().getBase().getDataSource();
        this.setAll((List)source.execute(sel.asString(), this.handler));
    }

    public int indexFromID(int id) {
        int i = 0;
        while (i < this.getDisplayedItems().size()) {
            SQLRow row = (SQLRow)this.getDisplayedItems().get(i);
            if (row != this.getALLValue() && row.getID() == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    protected String toString(SQLRow item) {
        return this.getElement().getDescription(item);
    }

    public final SQLElement getElement() {
        return this.element;
    }

    @Override
    public void rowAdded(SQLTable table, int id) {
        this.reload();
    }

    @Override
    public void rowModified(SQLTable table, int id) {
        this.reload();
    }

    @Override
    public void rowDeleted(SQLTable table, int id) {
        this.reload();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " on " + this.getElement();
    }

    protected void die() {
        this.getElement().getTable().removeTableListener(this);
    }

    @Override
    protected void idsChanged() {
        this.reload();
    }

    @Override
    protected boolean hasALLValue() {
        return true;
    }
}

