/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.navigator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.navigator.SQLListModel;

public class ElementsSQLListModel
extends SQLListModel<SQLElement> {
    private final List<SQLElement> elements;
    private final Map<SQLElement, Number> counts = new HashMap<SQLElement, Number>();

    public ElementsSQLListModel(List<SQLElement> elements) {
        if (elements.size() == 0) {
            throw new IllegalArgumentException("elements empty");
        }
        this.elements = new ArrayList<SQLElement>(elements);
    }

    @Override
    protected void reload() {
        this.counts.clear();
        ArrayList<SQLElement> res = new ArrayList<SQLElement>(this.elements.size());
        for (SQLElement elem : this.elements) {
            res.add(elem);
        }
        this.setAll(res);
    }

    private final int getCount(SQLElement elem) {
        if (!this.counts.containsKey(elem)) {
            SQLSelect sel = new SQLSelect(elem.getTable().getBase());
            sel.addSelectFunctionStar("count");
            sel.setWhere(new Where(elem.getTable().getField(elem.getParentForeignField()), this.getIds()));
            Number count = (Number)elem.getTable().getBase().getDataSource().executeScalar(sel.asString());
            this.counts.put(elem, count);
        }
        return this.counts.get(elem).intValue();
    }

    @Override
    protected String toString(SQLElement e) {
        return String.valueOf(e.getPluralName()) + " (" + this.getCount(e) + ")";
    }

    @Override
    protected void idsChanged() {
        this.reload();
    }
}

