/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.navigator;

import java.util.List;
import javax.swing.ListSelectionModel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.navigator.ElementsSQLListModel;
import org.openconcerto.sql.navigator.RowsSQLBrowserColumn;
import org.openconcerto.sql.navigator.SQLBrowserColumn;

public class ElementsSQLBrowserColumn
extends SQLBrowserColumn<SQLElement, ElementsSQLListModel> {
    private final SQLElement parent;

    public ElementsSQLBrowserColumn(SQLElement parent, List<SQLElement> elements) {
        super(new ElementsSQLListModel(elements), false);
        this.parent = parent;
    }

    @Override
    protected int getSelectionMode() {
        return 0;
    }

    @Override
    public SQLTable getTable() {
        return this.previous().getTable();
    }

    @Override
    public List<Integer> getSelectedIDs() {
        return this.previous().getSelectedIDs();
    }

    @Override
    public List<SQLRow> getSelectedRows() {
        return this.previous().getSelectedRows();
    }

    @Override
    protected SQLBrowserColumn selectionChanged(ListSelectionModel m) {
        SQLElement sel = (SQLElement)this.list.getSelectedValue();
        RowsSQLBrowserColumn res = new RowsSQLBrowserColumn(sel, this.previous().isSearchable());
        res.setParentIDs(this.previousRowsColumn().getSelectedIDs());
        return res;
    }

    @Override
    protected String getHeaderName() {
        String res;
        if (this.parent == null) {
            res = "Selection";
        } else {
            String name = "Contenu des " + this.parent.getPluralName();
            res = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        }
        return res;
    }

    @Override
    public void setSelectedRow(SQLRow r) {
        SQLElement elem = Configuration.getInstance().getDirectory().getElement(r.getTable());
        this.setSelectedValue(elem);
        this.next().setSelectedRow(r);
    }

    @Override
    protected void live() {
    }

    @Override
    protected void die() {
    }
}

