/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.navigator;

import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.navigator.SQLBrowser;
import org.openconcerto.ui.state.ListenerXMLStateManager;
import org.openconcerto.utils.ExceptionHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BrowserStateManager
extends ListenerXMLStateManager<SQLBrowser, HierarchyListener> {
    public BrowserStateManager(SQLBrowser b, File f) {
        this(b, f, true);
    }

    public BrowserStateManager(SQLBrowser b, File f, boolean autosave) {
        super(b, f, autosave);
    }

    @Override
    protected HierarchyListener createListener() {
        return new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                boolean displayabilityChanged;
                boolean bl = displayabilityChanged = (e.getChangeFlags() & 2L) != 0L;
                if (displayabilityChanged && !e.getChanged().isDisplayable()) {
                    try {
                        BrowserStateManager.this.saveState();
                    }
                    catch (IOException exn) {
                        ExceptionHandler.handle((Component)BrowserStateManager.this.getSrc(), "Impossible de sauvegarder la taille des colonnes", exn);
                    }
                }
            }
        };
    }

    @Override
    protected void addListener(HierarchyListener l) {
        ((SQLBrowser)this.getSrc()).addHierarchyListener(l);
    }

    @Override
    protected void rmListener(HierarchyListener l) {
        ((SQLBrowser)this.getSrc()).removeHierarchyListener(l);
    }

    @Override
    protected void writeState(PrintStream out) throws IOException {
        SQLRow sel;
        out.println("<browser>");
        List<SQLRow> selection = ((SQLBrowser)this.getSrc()).getSelectedRows();
        SQLRow sQLRow = sel = selection.isEmpty() ? null : selection.get(0);
        if (sel != null) {
            out.print("<selection");
            out.print(" id=\"" + sel.getID() + "\" >");
            out.print(sel.getTable().getSQLNameUntilDBRoot(true).quote());
            out.println("</selection>");
        }
        out.println("</browser>");
    }

    @Override
    protected boolean readState(Document doc) {
        SQLRow r = this.getSelection(doc);
        ((SQLBrowser)this.getSrc()).setSelectedRow(r);
        return true;
    }

    private SQLRow getSelection(Document doc) {
        SQLRow res;
        Node selection = doc.getElementsByTagName("selection").item(0);
        if (selection == null) {
            res = null;
        } else {
            int id = Integer.parseInt(selection.getAttributes().getNamedItem("id").getNodeValue());
            SQLName tableName = SQLName.parse(selection.getTextContent());
            try {
                SQLTable t = Configuration.getInstance().getBase().getDesc(tableName, SQLTable.class);
                res = t.getRow(id);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                return null;
            }
        }
        return res;
    }
}

