/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.AsUndirectedGraph;
import org.jgrapht.graph.DirectedMultigraph;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.BaseGraph;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;

public class GraFFF
extends BaseGraph {
    static GraFFF create(DirectedMultigraph<SQLTable, Link> g, List<SQLTable> linksToRemove) {
        DirectedMultigraph pg = (DirectedMultigraph)g.clone();
        Iterator<SQLTable> i = linksToRemove.iterator();
        while (i.hasNext()) {
            SQLTable t1 = i.next();
            SQLTable t2 = i.next();
            if (t1 != null && t2 != null) {
                pg.removeAllEdges(t1, t2);
                continue;
            }
            Log.get().config("cannot remove links between " + t1 + " and " + t2);
        }
        return new GraFFF(pg);
    }

    static GraFFF createKeep(DirectedMultigraph<SQLTable, Link> g, Set<SQLField> linksToKeep) {
        DirectedMultigraph pg = (DirectedMultigraph)g.clone();
        for (Link l : new HashSet(pg.edgeSet())) {
            if (linksToKeep.contains(l.getSingleField())) continue;
            pg.removeEdge(l);
        }
        return new GraFFF(pg);
    }

    private GraFFF(DirectedMultigraph<SQLTable, Link> g) {
        super(new AsUndirectedGraph<SQLTable, Link>((DirectedGraph<SQLTable, Link>)g));
    }

    public final Set<SQLTable> getDescTables(SQLTable t, SQLField parentF) {
        HashSet<SQLTable> res = new HashSet<SQLTable>();
        this.getDescTables(t, parentF, res);
        return res;
    }

    private final void getDescTables(SQLTable t, SQLField parentF, Set<SQLTable> beenThere) {
        beenThere.add(t);
        for (Link l : this.getGraph().edgesOf(t)) {
            if (beenThere.contains(l.oppositeVertex(t)) || parentF != null && parentF.equals(l.getSingleField())) continue;
            this.getDescTables(l.oppositeVertex(t), parentF, beenThere);
        }
    }

    public Path getShortestPath(SQLTable src, SQLTable dest) {
        return Path.create(src, DijkstraShortestPath.findPathBetween(this.getGraph(), src, dest));
    }

    public Set<Path> findAllPath(SQLTable from, SQLTable to) {
        return this.findAllPath(from, to, new Path(from));
    }

    private Set<Path> findAllPath(SQLTable from, SQLTable to, Path been) {
        if (from == to) {
            return Collections.singleton(been);
        }
        HashSet<Path> res = new HashSet<Path>();
        for (Link l : this.getGraph().edgesOf(from)) {
            SQLTable neighbour = l.oppositeVertex(from);
            if (been.getTables().contains(neighbour)) continue;
            Path newBeen = new Path(been);
            newBeen.add(l);
            res.addAll(this.findAllPath(neighbour, to, newBeen));
        }
        return res;
    }
}

