/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.ConnectivityInspector;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;

public abstract class BaseGraph {
    private Graph<SQLTable, Link> graph;

    protected BaseGraph(DirectedGraph<SQLTable, Link> g) {
        this.graph = g;
    }

    protected BaseGraph(UndirectedGraph<SQLTable, Link> g) {
        this.graph = g;
    }

    public String dump() {
        StringBuffer sb = new StringBuffer();
        Set<SQLTable> vertices = this.graph.vertexSet();
        for (SQLTable table : vertices) {
            sb.append(table.getSQLName()).append(table.hashCode()).append("\n");
        }
        sb.append("\n");
        Set<Link> edges = this.graph.edgeSet();
        for (Link l : edges) {
            SQLName src = ((SQLTable)l.getSource()).getSQLName();
            SQLName dest = ((SQLTable)l.getTarget()).getSQLName();
            sb.append(src).append("\t").append(dest).append("\t").append(l.getLabel().getName()).append("\n");
        }
        return sb.toString();
    }

    public Set<SQLTable> getConnectedSet(SQLTable table) {
        ConnectivityInspector insp = this.graph instanceof DirectedGraph ? new ConnectivityInspector((DirectedGraph)this.graph) : new ConnectivityInspector((UndirectedGraph)this.graph);
        return insp.connectedSetOf(table);
    }

    public final Set<SQLTable> getAllTables() {
        return this.graph.vertexSet();
    }

    protected Graph<SQLTable, Link> getGraph() {
        return this.graph;
    }
}

