/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRequestLogModel;

public class SQLRequestLog {
    private static final String ACTIVER_LA_CAPTURE = "Activer la capture";
    private static final String DESACTIVER_LA_CAPTURE = "D\u00e9sactiver la capture";
    private static List<SQLRequestLog> list = new ArrayList<SQLRequestLog>(500);
    private static boolean enabled;
    private String query;
    private String comment;
    private long startAsMs;
    private long durationSQLNano;
    private long durationTotalNano;
    private String stack;
    private boolean inSwing;
    private int connectionId;
    private boolean forShare;
    private String threadId;
    private static List<ChangeListener> listeners;
    private static JLabel textInfo;
    private static final SimpleDateFormat sdt;
    private static final DecimalFormat dformat;

    static {
        listeners = new ArrayList<ChangeListener>(2);
        textInfo = new JLabel("Total: ");
        sdt = new SimpleDateFormat("HH:MM:ss.SS");
        dformat = new DecimalFormat("##0.00");
    }

    public static void setEnabled(boolean enable) {
        enabled = enable;
    }

    public SQLRequestLog(String query, String comment, int connectionId, long starAtMs, long durationSQLNano, long durationTotalNano, String ex, boolean inSwing) {
        this.query = query;
        this.comment = comment;
        this.connectionId = connectionId;
        this.startAsMs = starAtMs;
        this.durationSQLNano = durationSQLNano;
        this.durationTotalNano = durationTotalNano;
        this.stack = ex;
        this.inSwing = inSwing;
        this.forShare = query.contains("FOR SHARE");
        if (this.forShare) {
            this.comment = "Utilise FOR SHARE. " + comment;
        }
        this.threadId = "[" + Thread.currentThread().getId() + "] " + Thread.currentThread().getName();
    }

    public static void log(String query, String comment, int hashCode, long starAtMs, long durationSQLNano, long durationTotalNano) {
        if (enabled) {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            new Exception().printStackTrace(new PrintStream(b));
            String ex = b.toString();
            list.add(new SQLRequestLog(query, comment, hashCode, starAtMs, durationSQLNano, durationTotalNano, ex, SwingUtilities.isEventDispatchThread()));
            SQLRequestLog.fireEvent();
        }
    }

    public static void log(String query, String comment, long starAtMs, long durationNano) {
        SQLRequestLog.log(query, comment, 0, starAtMs, durationNano, durationNano);
    }

    public static void log(String query, String comment, SQLDataSource.QueryInfo info, long starAtMs, long durationSQLNano, long durationTotalNano) {
        SQLRequestLog.log(query, comment, System.identityHashCode(info.getConnection()), starAtMs, durationSQLNano, durationTotalNano);
    }

    private static void fireEvent() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int stop = listeners.size();
                int i = 0;
                while (i < stop) {
                    ((ChangeListener)listeners.get(i)).stateChanged(null);
                    ++i;
                }
                long totalMs = SQLRequestLog.getTotalMs();
                long totalSQLMs = SQLRequestLog.getTotalSQLMs();
                textInfo.setText("Total: " + totalMs + " ms,  Swing: " + SQLRequestLog.getTotalSwing() + " ms, SQL: " + totalSQLMs + " ms, traitement: " + (totalMs - totalSQLMs) + " ms , " + SQLRequestLog.getNbConnections() + " connexions, " + SQLRequestLog.getNbThread() + " threads");
            }
        });
    }

    protected static int getNbConnections() {
        HashSet<Integer> s = new HashSet<Integer>();
        int stop = list.size();
        int i = 0;
        while (i < stop) {
            SQLRequestLog l = list.get(i);
            if (l.getConnectionId() > 0) {
                s.add(l.getConnectionId());
            }
            ++i;
        }
        return s.size();
    }

    protected static int getNbThread() {
        HashSet<String> s = new HashSet<String>();
        int stop = list.size();
        int i = 0;
        while (i < stop) {
            SQLRequestLog l = list.get(i);
            s.add(l.getThreadId());
            ++i;
        }
        return s.size();
    }

    protected static long getTotalMs() {
        int stop = list.size();
        long t = 0L;
        int i = 0;
        while (i < stop) {
            t += SQLRequestLog.list.get((int)i).durationTotalNano / 1000L;
            ++i;
        }
        return t / 1000L;
    }

    protected static long getTotalSQLMs() {
        int stop = list.size();
        long t = 0L;
        int i = 0;
        while (i < stop) {
            t += SQLRequestLog.list.get((int)i).durationSQLNano / 1000L;
            ++i;
        }
        return t / 1000L;
    }

    protected static long getTotalSwing() {
        int stop = list.size();
        long t = 0L;
        int i = 0;
        while (i < stop) {
            SQLRequestLog requestLog = list.get(i);
            if (requestLog.isInSwing()) {
                t += requestLog.durationTotalNano / 1000L;
            }
            ++i;
        }
        return t / 1000L;
    }

    public boolean isInSwing() {
        return this.inSwing;
    }

    public static void addChangeListener(ChangeListener l) {
        listeners.add(l);
    }

    public static void showFrame() {
        JFrame f = new JFrame("Requ\u00eates SQL");
        final SQLRequestLogModel model = new SQLRequestLogModel();
        final JTable table = new JTable(model);
        final TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(table.getModel());
        table.setRowSorter(sorter);
        table.getTableHeader().setReorderingAllowed(false);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    SQLRequestLog.showStack(model, sorter, table.getSelectedRow());
                }
            }
        });
        DefaultTableCellRenderer cellRendererDate = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel tableCellRendererComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                tableCellRendererComponent.setText(sdt.format(value));
                return tableCellRendererComponent;
            }
        };
        table.getColumnModel().getColumn(0).setCellRenderer(cellRendererDate);
        table.getColumnModel().getColumn(0).setMaxWidth(80);
        table.getColumnModel().getColumn(0).setMinWidth(80);
        DefaultTableCellRenderer cellRendererDuration = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel tableCellRendererComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                long l = (Long)value;
                if (l == 0L) {
                    tableCellRendererComponent.setText("");
                } else {
                    tableCellRendererComponent.setText(String.valueOf(dformat.format((double)l / 1000000.0)) + " ms");
                }
                return tableCellRendererComponent;
            }
        };
        cellRendererDuration.setHorizontalAlignment(4);
        table.getColumnModel().getColumn(1).setCellRenderer(cellRendererDuration);
        table.getColumnModel().getColumn(1).setMaxWidth(160);
        table.getColumnModel().getColumn(1).setMinWidth(100);
        DefaultTableCellRenderer cellRendererDurationSQL = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel tableCellRendererComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                long l = (Long)value;
                if (l == 0L) {
                    tableCellRendererComponent.setText("");
                } else {
                    tableCellRendererComponent.setText(String.valueOf(dformat.format((double)l / 1000000.0)) + " ms");
                }
                if (!isSelected) {
                    int b;
                    SQLRequestLog rowAt = model.getRowAt(sorter.convertRowIndexToModel(row));
                    float ratio = 1.0f;
                    if (rowAt.durationTotalNano > 0L && rowAt.durationTotalNano - rowAt.durationSQLNano > 2000000L) {
                        ratio = (float)rowAt.durationSQLNano / (float)rowAt.durationTotalNano;
                    }
                    if ((b = Math.round(255.0f * (ratio * ratio))) < 0) {
                        b = 0;
                    }
                    if (b > 255) {
                        b = 255;
                    }
                    tableCellRendererComponent.setBackground(new Color(255, 255, b));
                    tableCellRendererComponent.setForeground(Color.BLACK);
                }
                return tableCellRendererComponent;
            }
        };
        cellRendererDurationSQL.setHorizontalAlignment(4);
        table.getColumnModel().getColumn(2).setCellRenderer(cellRendererDurationSQL);
        table.getColumnModel().getColumn(2).setMaxWidth(160);
        table.getColumnModel().getColumn(2).setMinWidth(100);
        DefaultTableCellRenderer cellRendererTraitement = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel tableCellRendererComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                long l = (Long)value;
                if (l == 0L) {
                    tableCellRendererComponent.setText("");
                } else {
                    tableCellRendererComponent.setText(String.valueOf(dformat.format((double)l / 1000000.0)) + " ms");
                }
                if (!isSelected) {
                    if (l > 100000000L) {
                        tableCellRendererComponent.setBackground(new Color(254, 254, 0));
                    } else {
                        tableCellRendererComponent.setBackground(Color.WHITE);
                    }
                    tableCellRendererComponent.setForeground(Color.BLACK);
                }
                return tableCellRendererComponent;
            }
        };
        cellRendererTraitement.setHorizontalAlignment(4);
        table.getColumnModel().getColumn(3).setCellRenderer(cellRendererTraitement);
        table.getColumnModel().getColumn(3).setMaxWidth(160);
        table.getColumnModel().getColumn(3).setMinWidth(100);
        DefaultTableCellRenderer cellRendererQuery = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel tableCellRendererComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    if (model.getRowAt(sorter.convertRowIndexToModel(row)).isForShare()) {
                        tableCellRendererComponent.setBackground(new Color(254, 254, 150));
                    } else {
                        tableCellRendererComponent.setBackground(Color.WHITE);
                    }
                    tableCellRendererComponent.setForeground(Color.BLACK);
                }
                return tableCellRendererComponent;
            }
        };
        table.getColumnModel().getColumn(5).setCellRenderer(cellRendererQuery);
        table.getColumnModel().getColumn(6).setMaxWidth(100);
        table.getColumnModel().getColumn(6).setMinWidth(100);
        DefaultTableCellRenderer cellRendererThread = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel tableCellRendererComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    if (model.getRowAt(sorter.convertRowIndexToModel(row)).isInSwing()) {
                        tableCellRendererComponent.setBackground(new Color(254, 240, 240));
                    } else {
                        tableCellRendererComponent.setBackground(Color.WHITE);
                    }
                    tableCellRendererComponent.setForeground(Color.BLACK);
                }
                return tableCellRendererComponent;
            }
        };
        table.getColumnModel().getColumn(7).setCellRenderer(cellRendererThread);
        table.getColumnModel().getColumn(7).setMinWidth(100);
        JPanel p = new JPanel(new BorderLayout());
        JPanel bar = new JPanel(new FlowLayout());
        final JButton b0 = new JButton();
        if (enabled) {
            b0.setText(DESACTIVER_LA_CAPTURE);
        } else {
            b0.setText(ACTIVER_LA_CAPTURE);
        }
        b0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (enabled) {
                    enabled = false;
                    b0.setText(SQLRequestLog.ACTIVER_LA_CAPTURE);
                } else {
                    enabled = true;
                    b0.setText(SQLRequestLog.DESACTIVER_LA_CAPTURE);
                }
            }
        });
        bar.add(b0);
        JButton b1 = new JButton("Effacer tout");
        b1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRequestLog.clear();
            }
        });
        bar.add(b1);
        JButton b2 = new JButton("Afficher la stacktrace");
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int s = table.getSelectedRow();
                SQLRequestLog.showStack(model, sorter, s);
            }
        });
        bar.add(b2);
        p.add((Component)bar, "North");
        JScrollPane sc = new JScrollPane(table);
        p.add((Component)sc, "Center");
        p.add((Component)textInfo, "South");
        f.setContentPane(p);
        f.setSize(960, 480);
        f.setVisible(true);
        f.setDefaultCloseOperation(0);
        f.setVisible(true);
    }

    protected static synchronized void clear() {
        list.clear();
        SQLRequestLog.fireEvent();
    }

    public static synchronized int getSize() {
        return list.size();
    }

    public static synchronized SQLRequestLog get(int rowIndex) {
        return list.get(rowIndex);
    }

    public String getQuery() {
        return this.query;
    }

    public String getConnection() {
        return this.comment;
    }

    public long getStartAsMs() {
        return this.startAsMs;
    }

    public long getDurationTotalNano() {
        return this.durationTotalNano;
    }

    public long getDurationSQLNano() {
        return this.durationSQLNano;
    }

    public String getStack() {
        return this.stack;
    }

    public boolean isForShare() {
        return this.forShare;
    }

    public void printStack() {
        System.err.println("Stacktrace of : " + this.query);
        System.err.println(this.stack);
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public String getThreadId() {
        return this.threadId;
    }

    private static void showStack(SQLRequestLogModel model, TableRowSorter<TableModel> sorter, int s) {
        if (s >= 0 && s < model.getRowCount()) {
            SQLRequestLog rowAt = model.getRowAt(sorter.convertRowIndexToModel(s));
            rowAt.printStack();
            String text = "Thread: " + rowAt.getThreadId();
            if (rowAt.isInSwing()) {
                text = String.valueOf(text) + " (Swing)";
            }
            text = String.valueOf(text) + "\nD\u00e9but: " + sdt.format(rowAt.getStartAsMs()) + "\n";
            text = String.valueOf(text) + "Dur\u00e9e totale: " + dformat.format((double)rowAt.getDurationTotalNano() / 1000000.0) + " ms, dont " + dformat.format((double)rowAt.getDurationSQLNano() / 1000000.0) + " ms en SQL\n";
            text = String.valueOf(text) + rowAt.getQuery() + "\n" + rowAt.getStack();
            JTextArea area = new JTextArea(text);
            area.setFont(area.getFont().deriveFont(12.0f));
            area.setLineWrap(true);
            JFrame fStack = new JFrame("Stacktrace");
            fStack.setContentPane(new JScrollPane(area));
            fStack.pack();
            fStack.setSize(800, 600);
            fStack.setLocationRelativeTo(null);
            fStack.setDefaultCloseOperation(2);
            fStack.setVisible(true);
        }
    }
}

