/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;

public class SQLQuery {
    public static String and(Collection<String> clause) {
        return SQLQuery.join(clause, " AND ");
    }

    public static String or(Collection<String> clause) {
        return SQLQuery.join(clause, " OR ");
    }

    public static String from(Collection<String> clause) {
        return SQLQuery.join(clause, ", ");
    }

    public static String archive(Collection clause) {
        ArrayList<String> fields = new ArrayList<String>(clause.size());
        Iterator iter = clause.iterator();
        while (iter.hasNext()) {
            String s = SQLQuery.toString(iter.next());
            fields.add(String.valueOf(s) + ".ARCHIVE=0");
        }
        return SQLQuery.and(fields);
    }

    private static String join(Collection<String> c, String sep) {
        String res = "";
        Iterator<String> iter = c.iterator();
        while (iter.hasNext()) {
            String s = SQLQuery.toString(iter.next());
            res = String.valueOf(res) + s;
            if (!iter.hasNext()) continue;
            res = String.valueOf(res) + sep;
        }
        return res;
    }

    private static String toString(Object obj) {
        String res = null;
        if (obj instanceof String) {
            res = (String)obj;
        } else if (obj instanceof SQLTable) {
            res = ((SQLTable)obj).getName();
        } else if (obj instanceof SQLField) {
            res = ((SQLField)obj).getFullName();
        } else {
            throw new IllegalArgumentException("only String, SQLTable or SQLField are allowed");
        }
        return res;
    }
}

