/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLFilterListener;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.GraFFF;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.utils.CollectionUtils;

public final class SQLFilter {
    private final SQLElementDirectory dir;
    private final GraFFF filterGraph;
    private final List<Set<SQLRow>> filteredIDs;
    private final List<SQLFilterListener> listeners;

    public static SQLFilter create(DBSystemRoot root, SQLElementDirectory dir) {
        Collection<SQLElement> elements = dir.getElements();
        HashSet<SQLField> toKeep = new HashSet<SQLField>(elements.size());
        for (SQLElement elem : elements) {
            String parentFF = elem.getParentForeignField();
            if (parentFF == null) continue;
            toKeep.add(elem.getTable().getField(parentFF));
        }
        return new SQLFilter(dir, root.getGraph().cloneForFilterKeep(toKeep));
    }

    public SQLFilter(SQLElementDirectory dir, GraFFF filterGraph) {
        this.dir = dir;
        this.filterGraph = filterGraph;
        this.filteredIDs = new ArrayList<Set<SQLRow>>();
        this.listeners = new ArrayList<SQLFilterListener>();
    }

    public Path getPath(SQLTable tableToDisplay) {
        Set<Path> paths;
        Path res = null;
        if (this.getDepth() > 0 && !(paths = this.getPaths(tableToDisplay, this.getLeafTable())).isEmpty()) {
            res = paths.iterator().next().reverse();
        }
        return res;
    }

    private Set<Path> getPaths(SQLTable tableToDisplay, SQLTable filterTable) {
        Path shortestPath = this.filterGraph.getShortestPath(filterTable, tableToDisplay);
        Set<Object> paths = shortestPath == null ? Collections.emptySet() : Collections.singleton(shortestPath);
        return paths;
    }

    public void setFilteredID(SQLTable table, Integer ID) {
        this.setFiltered(Collections.singletonList(Collections.singleton(new SQLRow(table, ID))));
    }

    public void setFiltered(List<Set<SQLRow>> r) {
        if (r.equals(this.filteredIDs)) {
            return;
        }
        int prevDepth = this.getDepth();
        SQLTable prevTable = this.getLeafTable();
        this.filteredIDs.clear();
        this.filteredIDs.addAll(r);
        SQLTable broadestTable = prevDepth < this.getDepth() ? prevTable : this.getLeafTable();
        this.fireConnected(broadestTable);
    }

    private int getDepth() {
        return this.filteredIDs.size();
    }

    public final Set<SQLRow> getLeaf() {
        return CollectionUtils.getFirst(this.filteredIDs);
    }

    private final SQLTable getLeafTable() {
        Set<SQLRow> leaf = this.getLeaf();
        return leaf == null ? null : leaf.iterator().next().getTable();
    }

    private final void fireConnected(SQLTable table) {
        Set<SQLTable> connectedSet;
        if (table == null) {
            connectedSet = this.filterGraph.getAllTables();
        } else {
            String parentForeignField = this.dir.getElement(table).getParentForeignField();
            connectedSet = this.filterGraph.getDescTables(table, table.getFieldRaw(parentForeignField));
        }
        for (SQLFilterListener l : this.listeners) {
            l.filterChanged(connectedSet);
        }
    }

    public String toString() {
        return "SQLFilter on: " + this.filteredIDs;
    }

    public void addListener(SQLFilterListener l) {
        this.listeners.add(l);
    }

    public void rmListener(SQLFilterListener l) {
        this.listeners.remove(l);
    }
}

