/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.CollectionMap;

public class SQLFieldsSet {
    private final CollectionMap<SQLTable, SQLField> tables = new CollectionMap(LinkedHashSet.class);
    private String name;

    public SQLFieldsSet() {
        this(new HashSet<SQLField>());
    }

    public SQLFieldsSet(Collection<SQLField> fields) {
        this.setFields(fields);
    }

    private void setFields(Collection<SQLField> fields) {
        this.tables.clear();
        for (SQLField field : fields) {
            this.add(field);
        }
    }

    public final void add(SQLField field) {
        this.tables.put((Object)field.getTable(), (Object)field);
    }

    public final void retain(SQLTable t) {
        this.tables.keySet().retainAll(Collections.singleton(t));
    }

    public final Set<SQLField> getFields(SQLTable table) {
        return (Set)this.tables.getNonNull(table);
    }

    public final Set<SQLField> getFields(String table) {
        HashSet<SQLField> res = new HashSet<SQLField>();
        for (SQLTable t : this.getTables()) {
            if (!t.getName().equals(table)) continue;
            res.addAll(this.getFields(t));
        }
        return res;
    }

    public final Set<String> getFieldsNames(SQLTable table) {
        HashSet<String> res = new HashSet<String>();
        for (SQLField f : this.getFields(table)) {
            res.add(f.getName());
        }
        return res;
    }

    public final Set<SQLTable> getTables() {
        return Collections.unmodifiableSet(this.tables.keySet());
    }

    public final Set<SQLField> asSet() {
        return new HashSet<SQLField>(this.tables.values());
    }

    public final void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " " + this.name;
    }
}

