/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.openconcerto.sql.model.DBStructureItemDB;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.HierarchyLevel;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.DatabaseGraph;
import org.openconcerto.sql.utils.SQLCreateRoot;
import org.openconcerto.sql.utils.SQL_URL;

public final class DBRoot
extends DBStructureItemDB {
    private DatabaseGraph graph = null;
    private final PropertyChangeListener l = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("graph")) {
                DBRoot.this.clearGraph();
            }
        }
    };

    static DBRoot get(SQLBase b, String n) {
        DBRoot ancestor = b.getDBRoot();
        DBStructureItemDB parent = ancestor == null ? b.getDB() : (DBStructureItemDB)ancestor.getParent();
        return (DBRoot)parent.getChild(n);
    }

    DBRoot(DBStructureItemJDBC delegate) {
        super(delegate);
        this.getDBSystemRoot().addListener(this.l);
    }

    @Override
    protected void onDrop() {
        this.getDBSystemRoot().rmListener(this.l);
        this.clearGraph();
        super.onDrop();
    }

    public final SQLBase getBase() {
        return this.getJDBC().getAncestor(SQLBase.class);
    }

    public SQLTable getTable(String name) {
        return (SQLTable)DBRoot.getJDBC(this.getChild(name));
    }

    public SQLTable getTableDesc(String name) {
        return this.getDescLenient(name, SQLTable.class);
    }

    public SQLTable findTable(String name) {
        return this.findTable(name, false);
    }

    public SQLTable findTable(String name, boolean mustExist) {
        if (this.contains(name)) {
            return this.getTable(name);
        }
        return this.getDBSystemRoot().findTable(name, mustExist);
    }

    public Set<SQLTable> getTables() {
        return this.getJDBC().getDescendants(SQLTable.class);
    }

    public SQLField getField(String name) {
        return this.getDesc(name, SQLField.class);
    }

    public final String getMetadata(String name) {
        return this.getSchema().getFwkMetadata(name);
    }

    public final SQLSchema getSchema() {
        return (SQLSchema)this.getJDBC().getNonNullDBParent();
    }

    public final boolean setMetadata(String name, String value) throws SQLException {
        return this.getSchema().setFwkMetadata(name, value);
    }

    private synchronized void clearGraph() {
        this.graph = null;
    }

    public synchronized DatabaseGraph getGraph() {
        if (this.graph == null) {
            this.graph = new DatabaseGraph(this.getDBSystemRoot().getGraph(), this);
        }
        return this.graph;
    }

    public void refetch() throws SQLException {
        if (this.getJDBC() instanceof SQLBase) {
            ((SQLBase)this.getJDBC()).fetchTables();
        } else if (this.getJDBC() instanceof SQLSchema) {
            this.getBase().fetchTables(Collections.singleton(this.getName()));
        } else {
            throw new IllegalStateException();
        }
    }

    public final SQLCreateRoot getDefinitionSQL(SQLSystem sys) {
        SQLCreateRoot res = new SQLCreateRoot(sys.getSyntax(), this.getName());
        for (String name : new TreeSet<String>(this.getChildrenNames())) {
            res.addTable(this.getTable(name).getCreateTable(sys));
        }
        return res;
    }

    public final String equalsDesc(DBRoot o) {
        return this.equalsDesc(o, null);
    }

    public final String equalsDesc(DBRoot o, SQLSystem otherSystem) {
        if (this == o) {
            return null;
        }
        if (o == null) {
            return "other is null";
        }
        if (!this.getChildrenNames().equals(o.getChildrenNames())) {
            return "unequal table names: " + this.getChildrenNames() + " != " + o.getChildrenNames();
        }
        for (SQLTable t : this.getDescs(SQLTable.class)) {
            String eqDesc = t.equalsDesc(o.getTable(t.getName()), otherSystem, true);
            if (eqDesc == null) continue;
            return "unequal " + t.getName() + ": " + eqDesc;
        }
        return null;
    }

    public final SQL_URL getURL() {
        String hostname = this.getServer().getHostname();
        if (hostname == null) {
            return null;
        }
        SQLSystem system = this.getServer().getSQLSystem();
        String url = String.valueOf(system.name().toLowerCase()) + "://" + this.getDBSystemRoot().getDataSource().getUsername() + "@" + hostname + "/";
        if (system.getDBLevel(DBSystemRoot.class) != HierarchyLevel.SQLSERVER) {
            url = String.valueOf(url) + this.getDBSystemRoot().getName() + "/";
        }
        url = String.valueOf(url) + this.getName();
        try {
            return SQL_URL.create(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("could not produce url for " + this, e);
        }
    }

    public String dump() {
        String res = "";
        for (String tableName : new TreeSet<String>(this.getChildrenNames())) {
            SQLTable table = this.getTable(tableName);
            res = String.valueOf(res) + table + "\n";
            for (String fieldName : new TreeSet<String>(table.getFieldsName())) {
                SQLField f = table.getField(fieldName);
                res = String.valueOf(res) + f.getName() + " t: " + f.getType() + " def: " + f.getDefaultValue() + "\n";
            }
            res = String.valueOf(res) + "\n";
        }
        return res;
    }
}

