/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;

public class AliasedField
implements FieldRef {
    private final SQLField f;
    private final String alias;

    public AliasedField(SQLField f) {
        this(f, null);
    }

    public AliasedField(SQLField f, String alias) {
        if (f == null) {
            throw new NullPointerException("f is null");
        }
        this.f = f;
        this.alias = alias == null ? f.getTable().getName() : alias;
    }

    @Override
    public SQLField getField() {
        return this.f;
    }

    @Override
    public String getFieldRef() {
        return String.valueOf(SQLBase.quoteIdentifier(this.alias)) + "." + SQLBase.quoteIdentifier(this.getField().getName());
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AliasedField) {
            AliasedField o = (AliasedField)obj;
            return this.getAlias().equals(o.getAlias()) && this.getField().equals(o.getField());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getAlias().hashCode() + this.getField().hashCode();
    }

    public String toString() {
        return this.getFieldRef();
    }
}

