/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.awt.Component;
import java.util.Map;
import javax.swing.JPanel;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.utils.cc.ConstantFactory;
import org.openconcerto.utils.cc.IFactory;
import org.openconcerto.utils.checks.ValidObject;

public abstract class SQLComponent
extends JPanel
implements ValidObject {
    private final SQLElement element;
    private ElementSQLObject parent;
    private boolean inited;
    private Mode mode;
    private IFactory<SQLRowValues> defaults;

    protected SQLComponent(SQLElement element) {
        this.setOpaque(true);
        this.parent = null;
        this.element = element;
        this.mode = null;
        this.inited = false;
        this.clearDefaults();
    }

    public final Mode getMode() {
        return this.mode;
    }

    public ResetMode getResetMode() {
        return ResetMode.ON_SHOW;
    }

    public final boolean isInited() {
        return this.inited;
    }

    public final void setMode(Mode m) {
        if (this.isInited() || this.getMode() != null) {
            throw new IllegalStateException("mode already set: " + (Object)((Object)this.getMode()));
        }
        this.mode = m;
    }

    public abstract void setEditable(boolean var1);

    public abstract int insert();

    public abstract int insert(SQLRow var1);

    public abstract void select(int var1);

    public abstract void select(SQLRowAccessor var1);

    public abstract void detach();

    public abstract int getSelectedID();

    public abstract void update();

    public abstract void archive();

    public final void uiInit() {
        if (this.isInited()) {
            throw new IllegalStateException("already inited");
        }
        this.addViews();
        this.resetValue();
        this.inited();
        this.inited = true;
    }

    protected void inited() {
    }

    protected SQLRowValues createDefaults() {
        return this.defaults.createChecked();
    }

    public final void clearDefaults() {
        this.setDefaultsFactory(ConstantFactory.<SQLRowValues>nullFactory());
    }

    public final void setDefaults(Map<String, ?> defaults) {
        if (defaults == null) {
            throw new NullPointerException();
        }
        this.setDefaults(new SQLRowValues(this.getTable(), defaults));
    }

    public final void setDefaults(SQLRowValues defaults) {
        this.setDefaultsFactory(new ConstantFactory<SQLRowValues>(defaults));
    }

    public final void setDefaultsFactory(IFactory<SQLRowValues> defaults) {
        this.defaults = defaults;
    }

    protected abstract void addViews();

    public final SQLElement getElement() {
        return this.element;
    }

    protected final SQLTable getTable() {
        return this.getElement().getTable();
    }

    public abstract void resetValue();

    public abstract boolean isNonExistantEditable();

    public abstract void setNonExistantEditable(boolean var1);

    void setSQLParent(ElementSQLObject parent) {
        this.parent = parent;
    }

    public final ElementSQLObject getSQLParent() {
        return this.parent;
    }

    public boolean isPrivate() {
        return this.getSQLParent() != null;
    }

    public void analyze() {
        Component c;
        System.out.println("Analyse");
        int i = 0;
        while (i < this.getComponentCount()) {
            c = this.getComponent(i);
            System.out.println(String.valueOf(i) + ":" + c.getClass() + " , " + c);
            ++i;
        }
        System.out.println("Analyse des SQLRowView");
        i = 0;
        while (i < this.getComponentCount()) {
            c = this.getComponent(i);
            if (c instanceof SQLRowItemView) {
                SQLRowItemView r = (SQLRowItemView)((Object)c);
                System.out.println(r.getSQLName());
            } else if (c instanceof JPanel) {
                JPanel p = (JPanel)c;
                int j = 0;
                while (j < p.getComponentCount()) {
                    Component c2 = p.getComponent(j);
                    if (c2 instanceof SQLRowItemView) {
                        SQLRowItemView r = (SQLRowItemView)((Object)c2);
                        System.out.println(":" + r.getSQLName());
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public static enum Mode {
        INSERTION,
        MODIFICATION;

    }

    public static enum ResetMode {
        ON_SHOW(true, false),
        ON_HIDE(false, true),
        ON_BOTH(true, true);

        private final boolean onShow;
        private final boolean onHide;

        private ResetMode(boolean onShow, boolean onHide) {
            this.onShow = onShow;
            this.onHide = onHide;
        }

        public final boolean isOnShow() {
            return this.onShow;
        }

        public final boolean isOnHide() {
            return this.onHide;
        }
    }
}

