/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.convert;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;

public class MergeTable
extends Changer<SQLTable> {
    public static final String MERGE_DEST_TABLE = "merge.destTable";
    private SQLTable destTable = null;

    public MergeTable(DBSystemRoot b) {
        super(b);
    }

    public final void setDestTable(SQLTable destTable) {
        this.destTable = destTable;
    }

    @Override
    protected Class<? extends DBStructureItem> getMaxLevel() {
        return SQLTable.class;
    }

    @Override
    public void setUpFromSystemProperties() {
        super.setUpFromSystemProperties();
        String prop = System.getProperty(MERGE_DEST_TABLE);
        if (prop == null) {
            throw new IllegalStateException("the system property merge.destTable is not defined");
        }
        this.setDestTable(this.getSystemRoot().getDesc(prop, SQLTable.class));
    }

    @Override
    protected void changeImpl(final SQLTable t) throws SQLException {
        this.getStream().println("merging " + t.getSQLName() + " into " + this.destTable.getSQLName() + "... ");
        if (!this.destTable.getChildrenNames().containsAll(t.getChildrenNames())) {
            throw new IllegalArgumentException(this.destTable.getSQLName() + " lacks " + CollectionUtils.substract(t.getChildrenNames(), this.destTable.getChildrenNames()));
        }
        String noLink = t.equalsChildrenNoLink(this.destTable, null);
        if (noLink != null) {
            throw new IllegalArgumentException(noLink);
        }
        ArrayList<SQLField> fieldsNoPKNoOrder = new ArrayList<SQLField>(t.getFields());
        fieldsNoPKNoOrder.remove(t.getKey());
        SQLField orderF = t.getOrderField();
        fieldsNoPKNoOrder.remove(orderF);
        fieldsNoPKNoOrder.add(orderF);
        final String fields = "(" + CollectionUtils.join(fieldsNoPKNoOrder, ",", new ITransformer<SQLField, String>(){

            @Override
            public String transformChecked(SQLField input) {
                return SQLBase.quoteIdentifier(input.getName());
            }
        }) + ")";
        final SQLSelect sel = this.createSelect(t);
        fieldsNoPKNoOrder.remove(fieldsNoPKNoOrder.size() - 1);
        sel.addAllSelect(fieldsNoPKNoOrder);
        sel.addRawSelect(t.getBase().quote("%n + ( SELECT MAX(%n)+100 FROM %f ) ", orderF, this.destTable.getOrderField(), this.destTable), null);
        final SQLSelect selOldIDs = this.createSelect(t);
        selOldIDs.addSelect(t.getKey());
        final SQLSyntax syntax = t.getServer().getSQLSystem().getSyntax();
        SQLUtils.executeAtomic(t.getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, SQLException>(){

            @Override
            public Object handle(SQLDataSource ds) throws SQLException {
                Integer oldUndef;
                List<Number> insertedIDs = SQLRowValues.insertIDs(MergeTable.this.destTable, String.valueOf(fields) + " " + sel.asString());
                insertedIDs.add(0, MergeTable.this.destTable.getUndefinedID() == -1 ? null : Integer.valueOf(MergeTable.this.destTable.getUndefinedID()));
                List oldIDs = ds.executeCol(selOldIDs.asString());
                Integer n = oldUndef = t.getUndefinedID() == -1 ? null : Integer.valueOf(t.getUndefinedID());
                if (oldUndef == null) {
                    throw new UnsupportedOperationException("old undef is null, not yet supported");
                }
                oldIDs.add(0, oldUndef);
                int size = insertedIDs.size();
                if (size != oldIDs.size()) {
                    throw new IllegalStateException("size mismatch: " + size + " != " + oldIDs.size());
                }
                SQLName mapName = new SQLName("MAP");
                SQLCreateTable createTable = new SQLCreateTable(t.getDBRoot(), mapName.getFirst());
                createTable.setPlain(true);
                createTable.setTemporary(true);
                createTable.addColumn("OLD_ID", syntax.getIDType());
                createTable.addColumn("NEW_ID", syntax.getIDType());
                ds.execute(createTable.asString());
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < size) {
                    sb.append("(" + oldIDs.get(i) + ", " + insertedIDs.get(i) + ")");
                    if (i < size - 1) {
                        sb.append(",");
                    }
                    ++i;
                }
                ds.execute(t.getBase().quote("INSERT INTO %i(%i, %i) VALUES" + sb, mapName, "OLD_ID", "NEW_ID"));
                Set<Link> referentLinks = t.getDBSystemRoot().getGraph().getReferentLinks(t);
                for (Link refLink : referentLinks) {
                    SQLField refKey = refLink.getLabel();
                    SQLTable refTable = refKey.getTable();
                    if (refLink.getName() != null) {
                        AlterTable dropFK = new AlterTable(refTable);
                        dropFK.dropForeignConstraint(refLink.getName());
                        ds.execute(dropFK.asString());
                    }
                    String start = t.getServer().getSQLSystem() == SQLSystem.MYSQL ? t.getBase().quote("UPDATE %f, %i set %n = %i", refTable, mapName, refKey, new SQLName("MAP", "NEW_ID")) : t.getBase().quote("UPDATE %f set %n = %i FROM %i", refTable, refKey, new SQLName("MAP", "NEW_ID"), mapName);
                    ds.execute(String.valueOf(start) + t.getBase().quote(" where %n = %i", refKey, new SQLName("MAP", "OLD_ID")));
                    AlterTable addFK = new AlterTable(refTable);
                    addFK.addForeignConstraint(Collections.singletonList(refKey.getName()), MergeTable.this.destTable.getContextualSQLName(refTable), false, MergeTable.this.destTable.getPKsNames());
                    ds.execute(addFK.asString());
                }
                ds.execute(t.getBase().quote("DROP TABLE %f", t));
                return null;
            }
        });
    }

    private final SQLSelect createSelect(SQLTable t) {
        SQLSelect sel = new SQLSelect(t.getBase(), true);
        sel.setExcludeUndefined(true);
        sel.addFieldOrder(t.getOrderField());
        return sel;
    }
}

