/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ql;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.imageio.ImageIO;

public class QLPrinter {
    private String host;
    private boolean highQuality;
    private boolean paperCutAuto;
    private int printWidth;
    private int port = 515;
    private int timeout = 10000;

    public QLPrinter(String hostname) {
        if (hostname == null || hostname.trim().length() == 0) {
            throw new IllegalArgumentException("Bad HostName : " + hostname);
        }
        this.host = hostname;
        this.paperCutAuto = true;
        this.printWidth = 62;
    }

    public void setHighQuality(boolean b) {
        this.highQuality = b;
    }

    public void setPrintWidth(int mm) {
        this.printWidth = mm;
    }

    public void setPaperCutAuto(boolean b) {
        this.paperCutAuto = b;
    }

    public void print(File f) throws IOException {
        BufferedImage img = ImageIO.read(f);
        this.print(img);
    }

    public void print(BufferedImage img) throws IOException {
        byte[] data = this.getContent(img);
        this.print(data);
    }

    private byte[] getContent(BufferedImage img) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        int nbLines = img.getHeight();
        int width = img.getWidth();
        int i = 0;
        while (i < 200) {
            out.write(0);
            ++i;
        }
        out.write(27);
        out.write(64);
        out.write(27);
        out.write(105);
        out.write(97);
        out.write(1);
        out.write(27);
        out.write(105);
        out.write(122);
        out.write(-58);
        out.write(10);
        out.write(this.printWidth);
        out.write(0);
        out.write(nbLines);
        out.write(nbLines >> 8);
        out.write(0);
        out.write(0);
        out.write(0);
        out.write(0);
        out.write(27);
        out.write(105);
        out.write(77);
        if (this.paperCutAuto) {
            out.write(64);
        } else {
            out.write(0);
        }
        out.write(27);
        out.write(105);
        out.write(65);
        out.write(1);
        out.write(27);
        out.write(105);
        out.write(75);
        if (!this.highQuality) {
            out.write(8);
        } else {
            out.write(72);
        }
        out.write(27);
        out.write(105);
        out.write(100);
        out.write(0);
        out.write(0);
        out.write(77);
        out.write(2);
        i = 0;
        while (i < nbLines) {
            int[] pixels = new int[width];
            img.getRGB(0, i, width, 1, pixels, 0, 4);
            try {
                byte[] encodedLine = this.encodeLine(pixels);
                if (encodedLine.length > 1) {
                    out.write(103);
                    out.write(0);
                    out.write(encodedLine.length);
                }
                out.write(encodedLine);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
        out.write(26);
        return out.toByteArray();
    }

    private byte[] encodeLine(int[] pixels) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(pixels.length);
        byte[] bytesToEncode = new byte[pixels.length / 8];
        int index = 0;
        int i = 0;
        while (i < bytesToEncode.length) {
            int points = 0;
            int j = 0;
            while (j < 8) {
                int c = pixels[pixels.length - index - 1];
                int r = (c & 0xFF0000) >> 16;
                int g = (c & 0xFF00) >> 8;
                int b = c & 0xFF;
                int grayScale = (int)(21.2671 * (double)r + 71.516 * (double)g + 7.2169 * (double)b);
                boolean isBlack = grayScale < 12000;
                points *= 2;
                if (isBlack) {
                    ++points;
                }
                ++index;
                ++j;
            }
            bytesToEncode[i] = (byte)points;
            ++i;
        }
        boolean emptyLine = true;
        int i2 = 0;
        while (i2 < bytesToEncode.length) {
            if (bytesToEncode[i2] != 0) {
                emptyLine = false;
                break;
            }
            ++i2;
        }
        if (emptyLine) {
            out.write(90);
        } else {
            ByteArrayOutputStream outTemp = new ByteArrayOutputStream();
            byte last = bytesToEncode[0];
            outTemp.write(last);
            boolean sameByteMode = false;
            int i3 = 1;
            while (i3 < bytesToEncode.length) {
                byte b = bytesToEncode[i3];
                if (b == last) {
                    if (sameByteMode) {
                        sameByteMode = true;
                        outTemp.write(b);
                    } else {
                        if (outTemp.size() > 1) {
                            this.send(out, outTemp.toByteArray(), sameByteMode);
                            outTemp = new ByteArrayOutputStream();
                            sameByteMode = false;
                        } else {
                            sameByteMode = true;
                        }
                        outTemp.write(b);
                    }
                } else if (sameByteMode) {
                    this.send(out, outTemp.toByteArray(), sameByteMode);
                    outTemp = new ByteArrayOutputStream();
                    sameByteMode = false;
                    outTemp.write(b);
                } else {
                    sameByteMode = false;
                    outTemp.write(b);
                }
                if (outTemp.size() > 120) {
                    this.send(out, outTemp.toByteArray(), sameByteMode);
                    outTemp = new ByteArrayOutputStream();
                    sameByteMode = false;
                }
                last = b;
                ++i3;
            }
            if (outTemp.size() > 0) {
                this.send(out, outTemp.toByteArray(), sameByteMode);
            }
        }
        return out.toByteArray();
    }

    private void send(ByteArrayOutputStream out, byte[] byteArray, boolean sameByteMode) throws IOException {
        if (sameByteMode) {
            out.write(257 - byteArray.length);
            out.write(byteArray[0]);
        } else {
            out.write(byteArray.length - 1);
            out.write(byteArray);
        }
    }

    private String getNewJobId() {
        String id = String.valueOf((int)Math.floor(Math.random() * 999.0));
        while (id.length() < 3) {
            id = "0" + id;
        }
        return id;
    }

    public void print(byte[] data) throws UnknownHostException, IOException {
        Socket socket = new Socket(InetAddress.getByName(this.host), this.port);
        socket.setSoTimeout(this.timeout);
        String queue = "lpr";
        String jobid = this.getNewJobId();
        if (socket != null) {
            String myHostName;
            try {
                myHostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                myHostName = "Host";
            }
            String user = "Java";
            String cfa = this.getCFA(myHostName, "Java", "Label", jobid);
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            out.write(2);
            out.writeBytes("lpr\n");
            out.flush();
            if (in.read() != 0) {
                throw new IOException("Error printing on queue");
            }
            out.write(2);
            out.writeBytes(String.valueOf(String.valueOf(cfa.length())) + " ");
            out.writeBytes("cfA" + jobid + "Java" + "\n");
            out.flush();
            if (in.read() != 0) {
                throw new IOException("Error sending start of control file");
            }
            out.writeBytes(cfa);
            out.writeByte(0);
            out.flush();
            if (in.read() != 0) {
                throw new IOException("Error sending control file");
            }
            out.write(3);
            out.writeBytes(String.valueOf(String.valueOf(data.length)) + " ");
            out.writeBytes("dfA" + jobid + "Java" + "\n");
            out.flush();
            if (in.read() != 0) {
                throw new IOException("Error sending start of data");
            }
            out.write(data);
            out.writeByte(0);
            out.flush();
            if (in.read() != 0) {
                throw new IOException("Error sending end of data");
            }
            out.flush();
            out.close();
            in.close();
            socket.close();
        }
    }

    private String getCFA(String myHostName, String user, String documentName, String jobid) {
        String cfA = "";
        cfA = String.valueOf(cfA) + "H" + myHostName + "\n";
        cfA = String.valueOf(cfA) + "P" + user + "\n";
        cfA = String.valueOf(cfA) + "J" + documentName + "\n";
        cfA = String.valueOf(cfA) + "ldfA" + jobid + user + "\n";
        cfA = String.valueOf(cfA) + "UdfA" + jobid + myHostName + "\n";
        cfA = String.valueOf(cfA) + "N" + documentName + "\n";
        return cfA;
    }
}

