/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.text;

import java.util.Arrays;
import org.jdom.Element;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.StyleProperties;
import org.openconcerto.openoffice.StyleStyle;
import org.openconcerto.openoffice.StyleStyleDesc;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.text.TextStyle;

public class ParagraphStyle
extends TextStyle {
    public static final StyleStyleDesc<ParagraphStyle> DESC = new StyleStyleDesc<ParagraphStyle>(ParagraphStyle.class, XMLVersion.OD, "paragraph", "P"){
        {
            this.getRefElementsMap().putAll((Object)"text:style-name", Arrays.asList("text:alphabetical-index-entry-template", "text:bibliography-entry-template", "text:h", "text:p", "text:illustration-index-entry-template", "text:index-source-style", "text:object-index-entry-template", "text:table-index-entry-template", "text:table-of-content-entry-template", "text:user-index-entry-template"));
            this.getRefElementsMap().putAll((Object)"draw:text-style-name", Arrays.asList("draw:caption", "draw:circle", "draw:connector", "draw:control", "draw:custom-shape", "draw:ellipse", "draw:frame", "draw:line", "draw:measure", "draw:path", "draw:polygon", "draw:polyline", "draw:rect", "draw:regular-polygon", "office:annotation"));
            this.getRefElementsMap().putAll((Object)"form:text-style-name", Arrays.asList("form:column"));
            this.getRefElementsMap().putAll((Object)"table:paragraph-style-name", Arrays.asList("table:body", "table:even-columns", "table:even-rows", "table:first-column", "table:first-row", "table:last-column", "table:last-row", "table:odd-columns", "table:odd-rows"));
        }

        @Override
        public ParagraphStyle create(ODPackage pkg, Element e) {
            return new ParagraphStyle(pkg, e);
        }
    };
    private StyleParagraphProperties pProps = null;

    public ParagraphStyle(ODPackage pkg, Element tableColElem) {
        super(pkg, tableColElem);
    }

    public final StyleParagraphProperties getParagraphProperties() {
        if (this.pProps == null) {
            this.pProps = new StyleParagraphProperties(this);
        }
        return this.pProps;
    }

    public final String getAlignment() {
        return this.getParagraphProperties().getAlignment();
    }

    public static class StyleParagraphProperties
    extends StyleProperties {
        public StyleParagraphProperties(StyleStyle style) {
            super(style, DESC.getFamily());
        }

        public final String getAlignment() {
            return this.getElement().getAttributeValue("text-align", this.getNS("fo"));
        }
    }
}

