/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.text;

import org.jdom.Element;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.text.Paragraph;

public class Heading
extends Paragraph {
    static Element createEmpty(XMLVersion ns) {
        return new Element("h", ns.getTEXT()).setAttribute("outline-level", "1", ns.getTEXT());
    }

    public Heading(String text) {
        this();
        this.addContent(text);
    }

    public Heading() {
        super(Heading.createEmpty(XMLVersion.getDefault()));
    }

    public final int getLevel() {
        String attr = this.getElement().getAttributeValue("outline-level", this.getElement().getNamespace());
        return attr == null ? 1 : Integer.parseInt(attr);
    }

    public final void setLevel(int level) {
        if (level < 1) {
            throw new IllegalArgumentException(String.valueOf(level) + " < 1");
        }
        this.getElement().setAttribute("outline-level", String.valueOf(level), this.getElement().getNamespace());
    }
}

